/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot.dataset;

import com.panayotis.gnuplot.dataset.DataSet;
import java.io.Serializable;

public class ArrayDataSet
implements DataSet,
Serializable {
    private String[][] val;

    public ArrayDataSet(double[][] values) {
        int length = values.length;
        int dimension = values[0].length;
        if (length == 0) {
            throw new ArrayStoreException("Array has zero points");
        }
        this.val = new String[length][dimension];
        for (int i = 0; i < length; ++i) {
            if (values[i].length != dimension) {
                throw new ArrayStoreException("Array has not consistent size, was " + dimension + ", found " + values[i].length);
            }
            for (int j = 0; j < dimension; ++j) {
                this.val[i][j] = Double.toString(values[i][j]);
            }
        }
    }

    public ArrayDataSet(float[][] values) {
        int length = values.length;
        int dimension = values[0].length;
        if (length == 0) {
            throw new ArrayStoreException("Array has zero points");
        }
        this.val = new String[length][dimension];
        for (int i = 0; i < length; ++i) {
            if (values[i].length != dimension) {
                throw new ArrayStoreException("Array has not consistent size, was " + dimension + ", found " + values[i].length);
            }
            for (int j = 0; j < dimension; ++j) {
                this.val[i][j] = Float.toString(values[i][j]);
            }
        }
    }

    public ArrayDataSet(int[][] values) {
        int length = values.length;
        int dimension = values[0].length;
        if (length == 0) {
            throw new ArrayStoreException("Array has zero points");
        }
        this.val = new String[length][dimension];
        for (int i = 0; i < length; ++i) {
            if (values[i].length != dimension) {
                throw new ArrayStoreException("Array has not consistent size, was " + dimension + ", found " + values[i].length);
            }
            for (int j = 0; j < dimension; ++j) {
                this.val[i][j] = Integer.toString(values[i][j]);
            }
        }
    }

    public ArrayDataSet(long[][] values) {
        int length = values.length;
        int dimension = values[0].length;
        if (length == 0) {
            throw new ArrayStoreException("Array has zero points");
        }
        this.val = new String[length][dimension];
        for (int i = 0; i < length; ++i) {
            if (values[i].length != dimension) {
                throw new ArrayStoreException("Array has not consistent size, was " + dimension + ", found " + values[i].length);
            }
            for (int j = 0; j < dimension; ++j) {
                this.val[i][j] = Long.toString(values[i][j]);
            }
        }
    }

    public ArrayDataSet(String[][] values) {
        int length = values.length;
        int dimension = values[0].length;
        if (length == 0) {
            throw new ArrayStoreException("Array has zero points");
        }
        this.val = new String[length][dimension];
        for (int i = 0; i < length; ++i) {
            if (values[i].length != dimension) {
                throw new ArrayStoreException("Array has not consistent size, was " + dimension + ", found " + values[i].length);
            }
            System.arraycopy(values, 0, this.val, 0, values.length);
        }
    }

    public int size() {
        return this.val.length;
    }

    public int getDimensions() {
        if (this.val[0] == null) {
            return -1;
        }
        return this.val[0].length;
    }

    public String getPointValue(int point, int dimension) {
        return this.val[point][dimension];
    }
}

