/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot.dataset;

import com.panayotis.gnuplot.dataset.DataSet;
import com.panayotis.gnuplot.dataset.parser.DataParser;
import com.panayotis.gnuplot.dataset.parser.DoubleDataParser;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDataSet
extends ArrayList<ArrayList<String>>
implements DataSet {
    private DataParser parser;

    public GenericDataSet() {
        this.parser = new DoubleDataParser();
    }

    public GenericDataSet(boolean first_column_date) {
        this.parser = new DoubleDataParser(first_column_date);
    }

    public GenericDataSet(DataParser parser) {
        this.parser = parser;
    }

    @Override
    public int getDimensions() {
        if (this.size() < 1) {
            return -1;
        }
        return ((ArrayList)this.get(0)).size();
    }

    @Override
    public String getPointValue(int point, int dimension) {
        return (String)((ArrayList)this.get(point)).get(dimension);
    }

    @Override
    public boolean add(ArrayList<String> point) throws NumberFormatException {
        this.checkData(point, this.getDimensions());
        return super.add(point);
    }

    @Override
    public void add(int index, ArrayList<String> point) throws NumberFormatException {
        this.checkData(point, this.getDimensions());
        super.add(index, point);
    }

    @Override
    public boolean addAll(Collection<? extends ArrayList<String>> pts) throws NumberFormatException {
        int old_dim = this.getDimensions();
        for (ArrayList<String> arrayList : pts) {
            old_dim = this.checkData(arrayList, old_dim);
        }
        return super.addAll(pts);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ArrayList<String>> pts) throws NumberFormatException {
        int old_dim = this.getDimensions();
        for (ArrayList<String> arrayList : pts) {
            old_dim = this.checkData(arrayList, old_dim);
        }
        return super.addAll(index, pts);
    }

    @Override
    public ArrayList<String> set(int index, ArrayList<String> point) throws NumberFormatException, ArrayIndexOutOfBoundsException {
        this.checkData(point, this.getDimensions());
        return super.set(index, point);
    }

    private int checkData(ArrayList<String> point, int old_dim) throws NumberFormatException {
        int new_dim = point.size();
        if (old_dim < 0) {
            old_dim = new_dim;
        }
        if (old_dim != new_dim) {
            throw new ArrayIndexOutOfBoundsException("Point inserted differs in dimension: found " + new_dim + ", requested " + old_dim);
        }
        for (int i = 0; i < point.size(); ++i) {
            if (this.parser.isValid(point.get(i), i)) continue;
            throw new NumberFormatException("The point added with value \"" + point.get(i) + "\" and index " + i + " is not valid with parser " + this.parser.getClass().getName());
        }
        return old_dim;
    }
}

