/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot.dataset;

import com.panayotis.gnuplot.dataset.DataSet;
import com.panayotis.gnuplot.dataset.Point;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointDataSet<N extends Number>
extends ArrayList<Point<N>>
implements DataSet {
    public PointDataSet() {
    }

    public PointDataSet(int initial) {
        super(initial);
    }

    public PointDataSet(Collection<? extends Point<N>> pts) throws NumberFormatException {
        super(pts);
        int length = this.size();
        int old_dim = this.getDimensions();
        for (int i = 0; i < length; ++i) {
            old_dim = this.checkDimension((Point)this.get(i), old_dim);
        }
    }

    private int checkDimension(Point<N> point, int old_dim) throws ArrayIndexOutOfBoundsException {
        int new_dim = point.getDimensions();
        if (old_dim < 0) {
            old_dim = new_dim;
        }
        if (old_dim != new_dim) {
            throw new ArrayIndexOutOfBoundsException("Point inserted differs in dimension: found " + new_dim + ", requested " + old_dim);
        }
        return old_dim;
    }

    @Override
    public boolean add(Point<N> point) throws NumberFormatException {
        this.checkDimension(point, this.getDimensions());
        return super.add(point);
    }

    @Override
    public void add(int index, Point<N> point) throws NumberFormatException {
        this.checkDimension(point, this.getDimensions());
        super.add(index, point);
    }

    @Override
    public boolean addAll(Collection<? extends Point<N>> pts) throws NumberFormatException {
        int old_dim = this.getDimensions();
        for (Point<N> p : pts) {
            old_dim = this.checkDimension(p, old_dim);
        }
        return super.addAll(pts);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Point<N>> pts) throws NumberFormatException {
        int old_dim = this.getDimensions();
        for (Point<N> p : pts) {
            old_dim = this.checkDimension(p, old_dim);
        }
        return super.addAll(index, pts);
    }

    @Override
    public Point<N> set(int index, Point<N> point) throws NumberFormatException {
        this.checkDimension(point, this.getDimensions());
        return super.set(index, point);
    }

    public void addPoint(N ... coords) {
        this.add(new Point(coords));
    }

    @Override
    public int getDimensions() {
        if (this.size() == 0) {
            return -1;
        }
        return ((Point)this.get(0)).getDimensions();
    }

    @Override
    public String getPointValue(int point, int dimension) {
        return ((Point)this.get(point)).get(dimension).toString();
    }

    public static final <N extends Number> PointDataSet<N> constructDataSet(Class<N> objclass, Object array) throws ArrayStoreException {
        if (!array.getClass().isArray()) {
            throw new ArrayStoreException("The second argument of constructDataSet should be a two dimensional array.");
        }
        int length = Array.getLength(array);
        int dim = -1;
        PointDataSet<N> points = new PointDataSet<N>(length);
        Number[] buffer = null;
        for (int i = 0; i < length; ++i) {
            Object row = Array.get(array, i);
            if (!row.getClass().isArray()) {
                throw new ArrayStoreException("The second argument of constructDataSet is a one dimensional, instead of two dimensional, array.");
            }
            int cdim = Array.getLength(row);
            if (dim < 0) {
                dim = cdim;
                buffer = (Number[])Array.newInstance(Number.class, dim);
            }
            if (dim != cdim) {
                throw new ArrayStoreException("Array has not consistent size, was " + dim + ", found " + cdim);
            }
            for (int j = 0; j < dim; ++j) {
                Object value = Array.get(row, j);
                if (!value.getClass().equals(objclass)) {
                    throw new ArrayStoreException("Array item " + value + " is " + value.getClass().getName() + " and not " + objclass.getName());
                }
                buffer[j] = (Number)value;
            }
            super.quickadd(new Point(buffer));
        }
        return points;
    }

    private void quickadd(Point<N> point) {
        super.add(point);
    }
}

