/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot.layout;

import com.panayotis.gnuplot.layout.GraphLayout;
import com.panayotis.gnuplot.plot.Graph;
import com.panayotis.gnuplot.plot.Page;
import java.io.Serializable;

public class GridGraphLayout
implements GraphLayout,
Serializable {
    public static final boolean HORIZONTAL = true;
    public static final boolean VERTICAL = false;
    private Start start = Start.UPLEFT;
    private boolean orientation = true;

    public void setStartPosition(Start start) {
        this.start = start;
    }

    public void setOrientation(boolean orientation) {
        this.orientation = orientation;
    }

    public void setDefinition(Page page, StringBuffer buffer) {
        int size = page.size();
        if (size <= 0) {
            return;
        }
        int height = (int)Math.floor(Math.sqrt(size));
        int width = (int)Math.ceil((double)size / (double)height);
        float dx = 1.0f / (float)width;
        float dy = 1.0f / (float)height;
        for (int index = 0; index < size; ++index) {
            int lin;
            int col;
            if (this.orientation) {
                col = index % width;
                lin = index / width;
            } else {
                lin = index % height;
                col = index / height;
            }
            if (this.start == Start.UPRIGHT || this.start == Start.DOWNRIGHT) {
                col = width - col - 1;
            }
            if (this.start == Start.UPLEFT || this.start == Start.UPRIGHT) {
                lin = height - lin - 1;
            }
            ((Graph)page.get(index)).setMetrics(dx * (float)col, dy * (float)lin, dx, dy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Start {
        UPLEFT,
        UPRIGHT,
        DOWNLEFT,
        DOWNRIGHT;

    }
}

