/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot.terminal;

import com.panayotis.gnuplot.terminal.TextFileTerminal;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import javax.swing.JPanel;

public class SVGTerminal
extends TextFileTerminal {
    public SVGTerminal() {
        this("");
    }

    public SVGTerminal(String filename) {
        super("svg", filename);
    }

    public String processOutput(InputStream stdout) {
        String out_status = super.processOutput(stdout);
        if (this.output != null && this.getOutputFile().equals("")) {
            this.output = this.output.replace("currentColor", "black");
        }
        return out_status;
    }

    public JPanel getPanel() throws ClassNotFoundException {
        Object svgDisplayPanel = null;
        if (this.output == null || this.output.equals("")) {
            throw new NullPointerException("SVG output is empty; probably SVG terminal is not used or plot() not executed yet.");
        }
        try {
            svgDisplayPanel = Class.forName("com.kitfox.svg.SVGDisplayPanel").newInstance();
            Object universe = Class.forName("com.kitfox.svg.SVGUniverse").newInstance();
            Object diagram = null;
            universe.getClass().getMethod("loadSVG", Reader.class, String.class).invoke(universe, new StringReader(this.output), "plot");
            URI uri = (URI)universe.getClass().getMethod("getStreamBuiltURI", String.class).invoke(universe, "plot");
            diagram = universe.getClass().getMethod("getDiagram", URI.class).invoke(universe, uri);
            svgDisplayPanel.getClass().getMethod("setDiagram", Class.forName("com.kitfox.svg.SVGDiagram")).invoke(svgDisplayPanel, diagram);
        }
        catch (NoSuchMethodException e) {
            throw new ClassNotFoundException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new ClassNotFoundException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ClassNotFoundException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ClassNotFoundException(e.getMessage());
        }
        catch (Exception e) {
            throw new ClassNotFoundException(e.getMessage());
        }
        return (JPanel)svgDisplayPanel;
    }
}

