package Comparators;

import GUI.ResultFilter;

public class DoubleEQFilter extends BaseFilter implements ResultFilter
{
	public DoubleEQFilter()
	{
		super();
		this.title = "DoubleEQFilter";
	}
	
	public String getTitle()
	{ 
		return this.title;
	}
	
	public void setTitle(String title)
	{
		this.title = title;
	}

	public String getShorthand() 
	{
		return "=";
	}

	public String toString() 
	{
		return "=";
	}

	public Boolean compare(String s1) 
	{
		try{
			Double d1 = new Double(s1);
			Double d2 = new Double(target);
			if(d1.equals(d2)) return true;
		}
		catch (Exception e){
			System.err.println("Error-DoubleEQFilter One or both of the strings is not a parsible Double: d1: \"" + s1 + "\" d2:\"" + target+ "\"");
		}
		return false;
	}
	
	public DoubleEQFilter createNewFilter()
	{
		return new DoubleEQFilter();
	}
}