package Comparators;

import GUI.ResultFilter;

public class DoubleNEFilter extends BaseFilter implements ResultFilter
{
	public DoubleNEFilter()
	{
		super();
		this.title = "DoubleNEFilter";
	}
	
	public String getTitle()
	{ 
		return this.title;
	}
	
	public void setTitle(String title)
	{
		this.title = title;
	}

	public String getShorthand() 
	{
		return "\u2260";
	}
	
	public String toString() 
	{
		return "\u2260";
	}	
	
	public Boolean compare(String s1) 
	{
		try{
			Double d1 = new Double(s1);
			Double d2 = new Double(target);
			if(!d1.equals(d2)) return true;
		}
		catch (Exception e){
			System.err.println("Error-DoubleNEFilter One or both of the strings is not a parsible Double: d1: \"" + s1 + "\" d2:\"" + target+ "\"");
		}
		return false;
	}
	
	public DoubleNEFilter createNewFilter()
	{
		return new DoubleNEFilter();
	}
}