package DataExtraction;

import java.io.FileInputStream;
import java.util.Scanner;

public class ASCIIParser {
	
	public Element parserFile(String fileName)
	{
		try 
		{
			Scanner scanner = new Scanner(new FileInputStream(fileName));
			Element root = new Element("results", null);
			
			Element active = root;
			boolean newBracket = true;
			while(scanner.hasNextLine())
			{
				String line = removeWhiteSpace(scanner.nextLine());
				if (line.length() == 0 || line.startsWith("Error") || line.startsWith("Done"))
					continue;
				if (line.replaceAll("=", "").length() == 0)
				{
					active = active.getParent();
					newBracket = true;
					continue;
				}
				if (line.endsWith(":")) line = line.substring(0, line.length() - 1);
				
				active.getChildren().add(createElementFromString(line, active));
				if (newBracket)
				{
					active = active.getChildren().get(active.getChildren().size() -1);
					newBracket = false;
				}
			}
			
			//Here we take the first bracket containing the parameters and add the title line as an element in an over-bracket called "Parameters"
			Element param = new Element("Parameters", root);
			Element title = root.getChildren().get(0);
			String[] titleNames = title.getTag().split("-");
			active = new Element(titleNames[0], param);
			active.setValue(titleNames[1]);
			param.addChild(active);
			for(Attribute att : title.getAttributes())
			{
				active = new Element(att.getName(), param);
				active.setValue(att.getValue());
				param.addChild(active);
			}
			for(Element ele : title.getChildren())
			{
				ele.setParent(param);
				param.addChild(ele);
			}
			root.removeChild(0);
			root.addChildToIndex(param, 0);
			
			return root;
		}
		catch(Exception e){
			e.printStackTrace();
			return null;
		}
	}
	
	private static String removeWhiteSpace(String line)
	{
		StringBuffer b = new StringBuffer(line.length());
		b.setLength(line.length());
		int current = 0;
		boolean toUpper = false;
		for (int i = 0; i < line.length(); i++)
		{
			char cur = line.charAt(i);
			if(!Character.isWhitespace(cur)) 
				if (toUpper)
				{
					b.setCharAt(current++, Character.toUpperCase(cur));
					toUpper = false;
				}
				else
					b.setCharAt(current++, cur);
			else toUpper = true;
		}
		
		return b.toString();
	}
	
	private static Element createElementFromString(String line, Element parent)
	{
		Element thisEle = new Element("", parent);
		int index = line.indexOf(";");	
		if (index >= 0)
		{
			thisEle.setTag(line.substring(0, index));
			line = extractAttributesFromString(line.substring(index), thisEle);
		}
		index = line.indexOf(":");
		if (index >= 0)
		{
			if (thisEle.getTag().length() == 0)
				thisEle.setTag(line.substring(0, index));
			line = line.substring(index + 1);
			index = line.indexOf("+-");
			if (index >= 0)
			{
				thisEle.setValue(line.substring(0, index).trim());
				thisEle.addAttribute("Error", line.substring(index + 2).trim());
			}
			else
				thisEle.setValue(line.trim());
		}
		if (thisEle.getTag().length() == 0)
			thisEle.setTag(line.trim());
		
		return thisEle;
	}
	
	private static String extractAttributesFromString(String line, Element ele)
	{
		int index = line.indexOf(";");
		while(index >= 0)
		{
			line = line.substring(1);
			index = line.indexOf(";");
			int end;
			if (index >= 0)
				end = index;
			else
			{
				int ind = line.indexOf(":");
				if (ind >= 0)
					end = ind;
				else
					end = line.length();
			}
			String att = line.substring(0, end);
			String[] attVals = att.split("=");
			ele.addAttribute(attVals[0], attVals[1].trim());
			line = line.substring(end);
		}
		
		return line;
	}

}
