package DataExtraction;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;


public class XMLHandler extends DefaultHandler {
	Element e = null;

	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		Element parent = e;
		e = new Element(qName, parent);
		if (parent != null)
			parent.addChild(e);

		for (int i = 0; i < attributes.getLength(); i++)
			e.addAttribute(attributes.getQName(i).trim(), attributes.getValue(i).trim());
	}

	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		if (e.getParent() != null)
			e = e.getParent();
	}

	public void characters(char ch[], int start, int length)
			throws SAXException {
		String value = new String(ch, start, length).trim();
		if (value.length() > 0)
			e.setValue(value.trim());
	}

	public Element getResult() {
		return e;
	}
}
