package FileFormats;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;

import GUI.FileFormatKeeper.FileFormat;

public class CSVFormat extends BaseFormat implements FileFormat{
	
	public CSVFormat(String s) 
	{
		super(s);
	}

	/**
	 * Saves to input data in a comma separated value (CSV) format to the indicated file
	 */
	public void saveToFile(File file, String[][] data)
	{
		if(data.length == 0) return;	//don't write a file with no data
		FileOutputStream fos;
		try 
		{
			fos = new FileOutputStream(file);
			OutputStreamWriter out = new OutputStreamWriter(fos, "UTF-8");
			
			StringBuilder sb = new StringBuilder();
			
			for(int i = 0; i < data[0].length; i++)
			{
				for(int j = 0; j < data.length; j++)
				{
					sb.append(data[j][i].replaceAll(",", "_"));
					if(j < data.length - 1)
						sb.append(',');
				}
				sb.append('\n');
			}
			
			out.write(sb.toString());
			
			out.close();
		} catch (Exception e) 
		{
			e.printStackTrace();
		} 
	}
}
