package FileFormats;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;

import GUI.FileFormatKeeper.FileFormat;

public class DATFormat extends BaseFormat implements FileFormat{

	public DATFormat(String s) {
		super(s);
	}

	public void saveToFile(File file, String[][] data) {
		if(data.length == 0) return;	//don't write a file with no data
		FileOutputStream fos;
		try 
		{
			fos = new FileOutputStream(file);
			OutputStreamWriter out = new OutputStreamWriter(fos, "UTF-8");
			
			StringBuilder sb = new StringBuilder();
			String first = null;
			
			for(int i = 0; i < data[0].length; i++)
			{
				if(first == null)
					first = data[0][i];
				else
					if(!first.equals(data[0][i]))
					{
						first = data[0][i];
						sb.append('\n');
					}
				for(int j = 0; j < data.length; j++)
				{
					sb.append(data[j][i]);
					if(j < data.length - 1)
						sb.append('\t');
				}
				sb.append('\n');
			}
			
			out.write(sb.toString());
			
			out.close();
		} catch (Exception e) 
		{
			e.printStackTrace();
		}
	}
}
