package Functions;

import java.awt.Component;
import java.util.List;

import javax.swing.JOptionPane;

import GUI.Equation;

public class AbsoluteValue extends BaseFunction implements Function{

	public AbsoluteValue()
	{
		this.numberOfParameters = 1;
		this.title = "abs";
	}

	public Double solve(List<String> parameters, Equation eq, Component comp) {

		if(parameters == null)
			return null;
		if(parameters.size() != this.numberOfParameters)
		{
			JOptionPane.showMessageDialog(comp, 
					"Function " + this.title + " requires " + this.numberOfParameters + " parameters",
					"Error",
					JOptionPane.ERROR_MESSAGE);
			return null;
		}
		Double[] dparams = getDoubles(parameters, eq);
		
		if(dparams[0] < 0)
			return -dparams[0];
		
		return dparams[0];
	}
	
}
