package Functions;

import java.awt.Component;
import java.util.List;

import javax.swing.JOptionPane;

import DataExtraction.Element;
import GUI.Equation;
import GUI.ValueTypeSplitter;

public class AverageCorrelation extends BaseFunction implements Function{

	public AverageCorrelation()
	{
		this.numberOfParameters = 1;
		this.title = "avgcorr";
	}
	
	public Double solve(List<String> parameters, Equation eq, Component comp)
	{
		if(parameters == null)
			return null;
		if(parameters.size() != this.numberOfParameters)
		{
			JOptionPane.showMessageDialog(comp, 
					"Function " + this.title + " requires " + this.numberOfParameters + " parameters",
					"Error",
					JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		Element corr = eq.getElement().getFirstChildByName(parameters.get(0));
		if(corr == null)
		{
			String ret = parameters.get(0) + " is not a valid correlation function, possible names are:\n";
			ValueTypeSplitter vs = new ValueTypeSplitter(eq.getElement());
			for(Element e : vs.getCorrelationParent().getChildren())
				ret += "\t" + e.getTag() + "\n";
			JOptionPane.showMessageDialog(comp, 
					ret,
					"Error",
					JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		Double avg = 0.0;
		
		int	last = (int) Double.parseDouble(corr.getChildren().get(corr.getChildren().size() - 1).getAttributeByName("Dx"));
		for(int x = 0; x < last + 1; x++)
		{
			for(int y = 0; y <= x; y++)
			{
				if(y == 0)
				{
					if(x == 0)
						avg += getPoint(corr, x, y);
					else
						avg += 4 * getPoint(corr, x, y);
				}
				else
				{
					if(x == y)
						avg += 4 * getPoint(corr, x, y);
					else
						avg += 8 * getPoint(corr, x, y);
				}
			}
		}
		Double sites = Math.pow(new Double((last * 2) + 1), 2.0);
		
		return avg / sites;
	}
	
	private Double getPoint(Element corr, int x, int y)
	{
		for(Element point : corr.getChildren())
		{
			int xp = (int)Double.parseDouble(point.getAttributeByName("Dx"));
			int yp = (int)Double.parseDouble(point.getAttributeByName("Dy"));
			if(x == xp && y == yp)
				return Double.parseDouble(point.getValue());
		}
		return 0.0;
	}
}
