package Functions;

import java.awt.Component;
import java.util.List;

import javax.swing.JOptionPane;

import GUI.Equation;

public class SquareRoot extends BaseFunction implements Function{

	public SquareRoot()
	{
		this.numberOfParameters = 1;
		this.title = "sqrt";
	}
	
	public Double solve(List<String> parameters, Equation eq, Component comp) {
		if(parameters == null)
			return null;
		if(parameters.size() != this.numberOfParameters)
		{
			JOptionPane.showMessageDialog(comp, 
					"Function " + this.title + " requires " + this.numberOfParameters + " parameters",
					"Error",
					JOptionPane.ERROR_MESSAGE);
			return null;
		}

		Double[] dparams = getDoubles(parameters, eq);
		
		return Math.sqrt(dparams[0]);
	}
	
}
