package GUI;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

import GUI.VariableMenuGenerator.VariableMenuListener;

public class CustomVariable {

    private final String COMMIT_ACTION = "commit";
    private enum Mode { INSERT, COMPLETION };    
    private Mode mode = Mode.INSERT;
    private final List<String> words;
	private final Map<String, Equation> aliasMap;
	private final JTextField titleField;
	private final JTextField equationField;
	private final JMenu customMenu;
	private final JFrame customWindow;
	private final JMenu mainMenu;
	private final VariableMenuListener ml;
    private GUIFrame base;
	
	CustomVariable(Map<String, Equation> aliasMap, JMenu customMenu, JMenu mainMenu, VariableMenuListener ml, GUIFrame base)
	{
		this.aliasMap = aliasMap;
		this.words = new ArrayList<String>();
		this.titleField = new JTextField("Enter variable name");
		this.equationField = new JTextField("Enter equation");
		Dimension oldDim = this.equationField.getPreferredSize();
		this.equationField.setPreferredSize(new Dimension(oldDim.width * 3, oldDim.height));
		this.customMenu = customMenu;
		this.customWindow = new JFrame("New Custom Variable");
		this.customWindow.setLocationRelativeTo(mainMenu);
		this.mainMenu = mainMenu;
		this.ml = ml;
		this.base = base;
	}
	
	private class CompletionTask implements Runnable{
		String completion;
		int position;
		JTextField textField;
		
		CompletionTask(String completion, int position, JTextField textField){
			this.completion = completion;
			this.position = position;
			this.textField = textField;
		}
		
		public void run(){
			StringBuffer text = new StringBuffer(textField.getText());
			text.insert(position, completion);
			textField.setText(text.toString());
			textField.setCaretPosition(position + completion.length());
			textField.moveCaretPosition(position);
			mode = Mode.COMPLETION;
		}
	}
	
	private class CommitAction extends AbstractAction {
		private static final long serialVersionUID = 1L;

		public void actionPerformed(ActionEvent ev) {
            if (mode == Mode.COMPLETION) {
                int pos = equationField.getSelectionEnd();
                StringBuffer text = new StringBuffer(equationField.getText());
                equationField.setText(text.toString());
                equationField.setCaretPosition(pos);
                mode = Mode.INSERT;
            } else {
				checkAndSetEquation();
            }
        }
    }
	
	public void showWindow()
	{
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));

		for(String s : aliasMap.keySet())
			words.add(s);
		Collections.sort(words);
		
		InputMap im = equationField.getInputMap();
		ActionMap am = equationField.getActionMap();
		im.put(KeyStroke.getKeyStroke("ENTER"), COMMIT_ACTION);
		am.put(COMMIT_ACTION, new CommitAction());
		
		titleField.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				checkAndSetEquation();
			}
		});
		mainPanel.add(titleField);
		
		equationField.getDocument().addDocumentListener(new DocumentListener(){
			public void changedUpdate(DocumentEvent arg0) {
			}
			public void removeUpdate(DocumentEvent arg0) {
			}
			public void insertUpdate(DocumentEvent arg0) {
				if(arg0.getLength() != 1) return;
				int pos = arg0.getOffset();
				String content = null;
				try{
					content = equationField.getText(0, pos + 1);
				}
				catch(BadLocationException e){
					e.printStackTrace();
				}
				
				int w;
				for(w = pos; w >= 0; w--)
					if(!Character.isLetter(content.charAt(w))) break;
				if(pos - w < 2) return;
				
				String prefix = content.substring(w + 1);
				int n = Collections.binarySearch(words, prefix);
				if(n < 0 && -n <= words.size())
				{
					String match = words.get(-n - 1);
					if(match.startsWith(prefix))
					{
						String completion = match.substring(pos - w);
						SwingUtilities.invokeLater(new CompletionTask(completion, pos + 1, equationField));
					}
				}
				else
					mode = Mode.INSERT;
			}
			
		});
		
		mainPanel.add(Box.createVerticalStrut(15));
		mainPanel.add(equationField);
		
		customWindow.add(mainPanel);
		customWindow.pack();
		customWindow.setVisible(true);
		
		SwingUtilities.updateComponentTreeUI(mainMenu);
	}
	
	private void checkAndSetEquation(){
		final String eqText = equationField.getText();
		final String titleText = titleField.getText();
		if(equationReady())
		{
			ml.setTitle(titleText);
			final Equation eq = new Equation(eqText, aliasMap);
			aliasMap.put(titleText, eq);
			ml.setEquation(eq);
			mainMenu.setText(titleText);
			final JMenuItem newCustomItem = new JMenuItem(titleText);
			newCustomItem.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent arg0) {
					ml.setTitle(titleText);
					ml.setEquation(eq);
					newCustomItem.setToolTipText(eqText);
				}
			});
			customMenu.add(newCustomItem, customMenu.getMenuComponentCount() - 1);
			customWindow.setVisible(false);
			customWindow.dispose();
			this.base.updateResultPanel();
		}
	}
	
	private boolean equationReady(){
		final String eqText = equationField.getText();
		final String titleText = titleField.getText();
		if(titleText.length() == 0 || titleText.equals("Enter variable name"))
		{
			JOptionPane.showMessageDialog(this.customWindow, "Must enter a variable name", "Error", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		if(eqText.length() == 0 || eqText.equals("Enter equation"))
		{
			JOptionPane.showMessageDialog(this.customWindow, "Must enter an equation", "Error", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		int lparens = eqText.replaceAll("[^(]", "").length();
		int rparens = eqText.replaceAll("[^)]", "").length();
		if(lparens - rparens != 0)
		{
			JOptionPane.showMessageDialog(this.customWindow, "Parentheses are not balanced", "Error", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		
		Equation eq = new Equation(eqText, aliasMap);
		if(eq.solve(this.base.getSample(), this.customWindow) == null)
			return false;
		
		return true;
	}
}
