package GUI;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import FileFormats.CSVFormat;
import FileFormats.DATFormat;

public class FileFormatKeeper {
	
	/**
	 * Used by all Format classes in the FileFormats package (except BaseFormat)
	 */
	public interface FileFormat{
		void saveToFile(File file, String[][] data);
		String getExtension();
	}
	
	//formats: List of file formats to be displayed when saving a file and used when a format is chosen
	private List<FileFormat> formats;
	
	public FileFormatKeeper()
	{
		this.formats = new ArrayList<FileFormat>();
		
		//Add each format in the FileFormats package
		//		Can this be automated?
		this.formats.add(new CSVFormat(".csv"));
		this.formats.add(new DATFormat(".dat"));
	}
	
	/**
	 * Get the FileFormat associated with the given extension
	 * @param ext extension of the file/file type
	 * @return the FileFormat with extension ext or null if no such FileFormat exists
	 */
	public FileFormat getFormat(String ext)
	{
		for(FileFormat ff : this.formats)
			if(ff.getExtension().equals(ext))
				return ff;
		return null;
	}
	
	/**
	 * Add filters to the file chooser so the user can only view certain file types
	 * @param fc the file chooser to be adjusted 
	 */
	public void setFileChooserFilters(JFileChooser fc)
	{
		for(final FileFormat ff : this.formats)
		{
			FileFilter filter = new FileFilter(){
				public boolean accept(File file) {	//allow files with the same extension, and directories
					String fileName = file.getName();
					return fileName.endsWith(ff.getExtension()) || file.isDirectory();
				}

				public String getDescription() {
					return "*" + ff.getExtension();
				}
			};
			fc.addChoosableFileFilter(filter);
		}
	}
}
