package GUI;

import DataExtraction.Element;

public class FileRoot {
	//String representation of the file path
	public String file;
	//Element containing all the data from the file
	public Element root;

	public FileRoot(String f, Element r) {
		file = f;
		root = r;
	}

	public FileRoot() {
		file = "";
		root = null;
	}
	
	public String toString() {
		return file + "\n" + root.toString();
	}
	
	/**
	 * Get shortened name of the file (file name + extension)
	 * @return
	 */
	public String getShortenedFile(){
		return this.file.substring(Math.max(this.file.lastIndexOf("/"), this.file.lastIndexOf("\\")) + 1);
	}
}
