package GUI;
import java.util.*;

import DataExtraction.Element;

public class FileRootList {
	//frl: List of FileRoots
	private List<FileRoot> frl;

	public FileRootList() {
		frl = new ArrayList<FileRoot>();
	}
	
	public FileRootList(List<FileRoot> list)
	{
		frl = list;
	}

	public List<FileRoot> getList(){
		return frl;
	}
	
	public FileRoot getFileRoot(int i) {
		return frl.get(i);
	}

	public void addFileRoot(FileRoot fr){
		frl.add(fr);
	}
	
	/**
	 * Remove a FileRoot from the list that has the same file name
	 * @param fileName
	 */
	public void removeFileRoot(String fileName){
		for(int i = 0; i < frl.size(); i++)
			if(frl.get(i).file.equals(fileName))
			{
				frl.remove(i);
				break;
			}
	}
	
	/**
	 * Remove a FileRoot based on its position in the list
	 * @param i
	 */
	public void removeFileRoot(int i){
		frl.remove(i);
	}

	public String getFile(int i) {
		return frl.get(i).file;
	}

	public Element getRoot(int i) {
		return frl.get(i).root;
	}

	/**
	 * Run the list of FileRoots through a list of ResultFilters and return a list of those that passed 
	 * @param filters
	 * @return
	 */
	public List<FileRoot> getFilteredRoots(List<ResultFilter> filters) 
	{
		List<FileRoot> filteredList = new ArrayList<FileRoot>();

		for (FileRoot fr : this.frl) {
			boolean works = true;
			for (ResultFilter filter : filters) {
				if(filter.getEquation() != null && filter.getTarget().length() > 0)
				{
					try{
						String v1 = filter.getEquation().solve(fr.root, null).toString();
						if(!filter.compare(v1))
						{
							works = false;
							break;
						}
					}
					catch(Exception e){
						works = false;
						break;
					}
				}
			}
			if(works)
			{
				filteredList.add(fr);
			}
		}

		return filteredList;
	}
}
