package GUI;
import java.util.*;

import DataExtraction.ASCIIParser;
import DataExtraction.Element;
import DataExtraction.XMLParser;

public class QUEST_Output {

	public static void main(String[] args) {

		List<FileRoot> frl = new ArrayList<FileRoot>();
		XMLParser xmlparser = new XMLParser();
		ASCIIParser parser = new ASCIIParser();
		String variableList = null;
		for (int i = 0; i < args.length; i++) {
			String fileName = args[i];
			if(i == 0 && fileName.endsWith(".xml"))
			{
					Element e = xmlparser.parserXMLFile(fileName);
					if(e != null)
						if(e.getTag().equals("variablelists"))
							variableList = fileName;
						else
							frl.add(new FileRoot(fileName, e));
					else
						System.err.println(fileName + " does not have a valid root");
			}
			else
			{
				Element e = parser.parserFile(fileName);
				if (e != null) {
					frl.add(new FileRoot(fileName, e));
				} 
				else
					System.err.println(fileName + " does not have a valid root");
			}
		}

		GUIFrame gf = new GUIFrame(frl, variableList);
		gf.executeGUI();
	}
}
