package GUI;
import java.util.*;

import DataExtraction.Element;

public class ValueTypeSplitter {
	//parameters: Element containing all parameters in the root
	private Element parameters;
	//correlations: List of correlations
	private List<Element> correlations;
	//nonCorrelations: List of Elements which are not parameters or correlations
	private List<Element> nonCorrelations;

	ValueTypeSplitter() {
	}

	public ValueTypeSplitter(Element root) {
		parameters = root.getFirstChildByName("Parameters");
		extractCorrelations(root);
		extractNonCorrelations(root);
	}

	/**
	 * Create a list of Elements each of which is a correlation in the root
	 * An Element is judged to be a correlation if and only if it has a Point as a child
	 * @param root
	 */
	private void extractCorrelations(Element root) {
		this.correlations = new ArrayList<Element>();

		for (Element bracket : root.getChildren()) {
			if (bracket.getFirstChildByName("Point") != null) {
				this.correlations.add(bracket);
			}
		}
	}

	/**
	 * Create a list of all Elements in root that are not parameters or correlations
	 * @param root
	 */
	private void extractNonCorrelations(Element root) {
		this.nonCorrelations = new ArrayList<Element>();

		for (Element bracket : root.getChildren())
			if (!bracket.getTag().equals("Parameters")
					&& bracket.getFirstChildByName("Point") == null)
				this.nonCorrelations.add(bracket);
	}

	public Element getParameters() {
		return parameters;
	}

	
	public Element getCorrelationParent() {
		Element parent = new Element("Correlations", null);

		for (Element child : correlations)
			parent.addChild(child);

		return parent;
	}

	public Element getNonCorrelationParent() {
		Element parent = new Element("Non-Correlations", null);

		for (Element child : nonCorrelations)
			parent.addChild(child);

		return parent;
	}

	/**
	 * Returns the maximum distance from the origin this root's correlations travel
	 * @return
	 */
	public Double getFarthestCorrPoint() {
		Double max = 0.0;
		for (Element point : correlations.get(0).getChildren()) {
			Double thisMax = Math.max(
					Double.parseDouble(point.getAttributeByName("Dx")),
					Double.parseDouble(point.getAttributeByName("Dy")));
			if (thisMax > max)
				max = thisMax;
		}
		return max;
	}
}
