package GUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.*;

import javax.swing.*;

import GUI.VariableMenuGenerator.VariableMenuListener;

public class VariableElement implements VariableMenuListener{
	//panel: the GUI panel associated with this variable
	private JPanel panel;
	//submenus: list of possibly settable menus. this list is used when the variable is removed
	private List<JMenu> submenus;
	//id: the unique ID associated with this variable
	private final UUID id;
	//base: the top level dialog associated with this application
	private GUIFrame base;
	//title: the title of this variable, changes as different variables are chosen
	private String title;
	//uparrow: a button that points up, for moving the variable up in the list
	private JButton uparrow;
	//downarrow: a button that points down, for moving the variable down in the list
	private JButton downarrow;
	//parent: the direct parent of this variable
	private final Variables parent;
	
	private JMenu extended;
	
	private JMenu mainMenu;
	
	private Equation equation;
	
	VariableElement(UUID id_i, GUIFrame base_i, Variables p) {
		this.id = id_i;
		this.base = base_i;
		this.parent = p;
		this.title = null;
		this.equation = null;
		initializePanel();
	}
		
	/**
	 * Initializes the variable element's GUI panel, including the menu lists, arrows, and removal button
	 */
	private void initializePanel()
	{
		this.panel = new JPanel();
		JMenuBar menubar = this.base.getVariableMenu(this);
		this.panel.add(menubar);
		this.mainMenu = (JMenu) menubar.getComponent(0);
		Component[] components = this.mainMenu.getMenuComponents();
		submenus = new ArrayList<JMenu>();
		for(Component comp : components)
		{
			JMenu menu = (JMenu) comp;
			if(menu.getText().equals("Extended"))
				this.extended = menu;
			submenus.add(menu);
		}
		
		JButton removeMe = new JButton("-");
		removeMe.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				parent.removeVariable(id, submenus);
			}
		});
		
		JPanel arrowPanel = new JPanel();
		arrowPanel.setLayout(new BoxLayout(arrowPanel, BoxLayout.Y_AXIS));
		
		uparrow = new JButton("\u2191");
		uparrow.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				parent.moveVariableUp(id);
			}
		});
		downarrow = new JButton("\u2193");
		downarrow.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				parent.moveVariableDown(id);
			}
		});
		Dimension currentDim = downarrow.getPreferredSize();
		Dimension shortDim = new Dimension(currentDim.width, currentDim.height / 2);
		uparrow.setPreferredSize(shortDim);
		downarrow.setPreferredSize(shortDim);
		
		arrowPanel.add(uparrow);
		arrowPanel.add(downarrow);
		
		this.panel.add(arrowPanel);
		this.panel.add(removeMe);
		this.panel.add(Box.createHorizontalGlue());
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public UUID getId() {
		return this.id;
	}

	public JPanel getPanel() {
		return this.panel;
	}
	
	public void setUpArrow(boolean b){
		this.uparrow.setEnabled(b);
		SwingUtilities.updateComponentTreeUI(this.panel);	
	}
	
	public void setDownArrow(boolean b){
		this.downarrow.setEnabled(b);
		SwingUtilities.updateComponentTreeUI(this.panel);	
	}

	@Override
	public void setEquation(Equation e) {
		this.equation = e;
	}

	@Override
	public Equation getEquation() {
		return equation;
	}
	
	public JMenu getExtended(){
		return this.extended;
	}
	
	public JMenu getMainMenu(){
		return this.mainMenu;
	}
	
	public void setExtended(JMenu extended){
		this.extended = extended;
	}
}
