package SpecialOutputs;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import DataExtraction.Element;
import GUI.FileRoot;
import GUI.FileRootList;
import GUI.GUIFrame;
import GUI.ValueTypeSplitter;

public class CorrReflected implements Runnable{
	private GUIFrame parent;
	private Element element;
	private int fileIndex;
	private JDialog dialog;

	public CorrReflected(GUIFrame parent){
		this.parent	= parent;
	}
	
	public String toString()
	{
		return "Reflected correlation set";
	}
	
	public void run()
	{
		this.dialog = new JDialog(this.parent, "Reflected correlation set");
		final JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
		final JButton nextButton = new JButton("Next");
		final JLabel label = new JLabel("Select the file to extract data from:");
		Box labelBox = Box.createHorizontalBox();
		labelBox.add(label);
		labelBox.add(Box.createHorizontalGlue());
		final FileRootList files = parent.getFilteredFileList();

		final DefaultListModel<String> fileModel = new DefaultListModel<String>();
		for (FileRoot fr : files.getList())
			fileModel.addElement(fr.getShortenedFile());
		final JList<String> fileList = new JList<String>(fileModel);
		fileList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		final ListSelectionListener lsl = new ListSelectionListener() {	 
			public void valueChanged(ListSelectionEvent e) {
				if (!e.getValueIsAdjusting()) {
					fileIndex = fileList.getSelectedIndex();
					if(fileIndex >= 0)
					{
						nextButton.setEnabled(true);
						element = files.getRoot(fileIndex);
					}
					else
					{
						nextButton.setEnabled(false);
					}
				}
			}
		};
		fileList.addListSelectionListener(lsl);
		
		JScrollPane jsp = new JScrollPane(fileList);
		jsp.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		jsp.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		
		nextButton.setEnabled(false);
		nextButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				selectCorrelation(panel);
			}
		});
		
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
		panel.add(labelBox);
		panel.add(jsp);
		panel.add(nextButton);
		
		dialog.add(panel);
		dialog.setMinimumSize(new Dimension(350, 250));
		dialog.setLocationRelativeTo(parent);
		dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		dialog.setVisible(true);
	}
	
	private void selectCorrelation(JPanel panel)
	{
		panel.removeAll();
		final JButton button = new JButton("Finish");
		final DefaultListModel<String> corrModel = new DefaultListModel<String>();
		final ValueTypeSplitter splitter = new ValueTypeSplitter(this.element);
		for(Element corr : splitter.getCorrelationParent().getChildren())
			corrModel.addElement(corr.getTag());
		final JList<String> corrList = new JList<String>(corrModel);
		corrList.addListSelectionListener(new ListSelectionListener() {	 
			public void valueChanged(ListSelectionEvent e) {
				if (!e.getValueIsAdjusting()) {
					fileIndex = corrList.getSelectedIndex();
					if(fileIndex >= 0)
					{
						button.setEnabled(true);
						element = splitter.getCorrelationParent().getChildren().get(fileIndex);
					}
					else
					{
						button.setEnabled(false);
					}
				}
			}
		});

		JScrollPane jsp = new JScrollPane(corrList);
		jsp.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		jsp.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		
		final JCheckBox showErrorsBox = new JCheckBox("Show error values");
		
		JLabel label = new JLabel("Select the correlation to extract data from:");
		Box labelBox = Box.createHorizontalBox();
		labelBox.add(label);
		labelBox.add(Box.createHorizontalGlue());
		button.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				setResults(showErrorsBox.isSelected());
			}
		});
		
		panel.add(labelBox);
		panel.add(jsp);
		panel.add(button);
		
		SwingUtilities.updateComponentTreeUI(panel);
	}
	
	private void setResults(Boolean showErrors)
	{
		JTable table = new JTable();
		String[] columnNames;
		if(showErrors)
			columnNames = new String[4];
		else
			columnNames = new String[3];

		columnNames[0] = "Dx"; columnNames[1] = "Dy"; columnNames[2] = this.element.getTag();
		if(showErrors)
			columnNames[3] = "Error";

		Double farthest = getFarthestCorrPoint();
		int farint = farthest.intValue();
		Element[][] points = new Element[farint * 2 + 1][farint * 2 + 1]; 
		for(Element point : this.element.getChildren())
		{
			int x = (int)Double.parseDouble(point.getAttributeByName("Dx"));
			int y = (int)Double.parseDouble(point.getAttributeByName("Dy"));
			points[x + farint][y + farint] = point;
		}
		for(int i = -farint; i <= farint; i++)
		{
			int avi = Math.abs(i);
			for(int j = -farint; j <= farint; j++)
			{
				int avj = Math.abs(j);
				if(avi >= avj)
					points[i + farint][j + farint] = points[avi + farint][avj + farint];
				else
					points[i + farint][j + farint] = points[avj + farint][avi + farint];
			}
		}

		int cols = points.length;
		int rows = points[0].length;
		String[][]data = new String[cols * rows][columnNames.length];
		for(int i = 0; i < cols; i++)
		{
			for(int j = 0; j < rows; j++)
			{
				Element point = points[i][j];
				Double dx = Double.parseDouble(point.getAttributeByName("Dx"));
				Double dy = Double.parseDouble(point.getAttributeByName("Dy"));
				int fi = i - farint;
				int fj = j - farint;
				if(Math.abs(fi) < Math.abs(fj))
				{
					if(fi < 0)
						dy *= -1.0;
					if(fj < 0)
						dx *= -1.0;
					data[i * rows + j][0] = dy.toString();
					data[i * rows + j][1] = dx.toString();
				}
				else
				{
					if(fi < 0)
						dx *= -1.0;
					if(fj < 0)
						dy *= -1.0;
					data[i * rows + j][0] = dx.toString();
					data[i * rows + j][1] = dy.toString();
				}
				data[i * rows + j][2] = point.getValue();
				if(showErrors)
					data[i * rows + j][3] = point.getAttributeByName("Error");
			}
		}
		
		table = new JTable(data, columnNames){
			private static final long serialVersionUID = 1L;

			public boolean isCellEditable(int row, int col){
				return false;
			}
		};

		table.setRowSelectionAllowed(true);
		table.setColumnSelectionAllowed(true);
		table.getTableHeader().setReorderingAllowed(false);
		
		this.dialog.dispose();
		this.parent.setResultTable(table, true);
	}

	public Double getFarthestCorrPoint() {
		Double max = 0.0;
		for (Element point : this.element.getChildren()) {
			Double thisMax = Math.max(
					Double.parseDouble(point.getAttributeByName("Dx")),
					Double.parseDouble(point.getAttributeByName("Dy")));
			if (thisMax > max)
				max = thisMax;
		}
		return max;
	}
}
