program test5

  ! This program test the dqmc_simqmc module.

  use dqmc_simqmc
  implicit none

  ! parameters
  integer, parameter  :: L  = 48
  integer, parameter  :: Nx = 4
  integer, parameter  :: Ny = 4
  integer, parameter  :: Nc = Nx*Ny
  integer, parameter  :: Na = 2
  integer, parameter  :: n  = Nc*(Na+1)
  integer, parameter  :: nL = n*L
  integer, parameter  :: nWarm = 0
  integer, parameter  :: nPass = 0
  real(wp), parameter :: U = 8.0D0
  real(wp), parameter :: dtau = 0.25D0
  integer, parameter  :: seed = 12345    ! if seed=0, system seed will 
                                         ! be randomly generated

  ! variables
  type(simqmc) :: qmc
  real(wp)     :: K(n,n), sup, sdn, val, diff_up, diff_dn
  real(wp), pointer  :: Gup(:,:), Gdn(:,:)
  real(wp)     :: Gup1(n*L,n*L), Gdn1(n*L,n*L)
  integer      :: i, j, row, col, ri, ci
  real         :: t1, t2, t3

  ! executables

  ! read K from Kmatrix.dat
  open(unit=10, file="Kmatrix.dat")
  read(10,*) 
  do i = 1,n
     do j =1,n
        read(10, *) row, col, val
        K(row, col) = val
     end do
  end do
  close(10)

  ! initialize qmc simulator
  call DQMC_QMC_Init(qmc, Nc, Na, L, U, dtau, K, nwarm, npass, seed, .true.)

  call cpu_time(t1)
  call DQMC_measure(qmc, Gup1, Gdn1, sup, sdn)
  call cpu_time(t2)
  ! Get Green's function
  
  do i = 1, L
     do j = 0, L-1
        call DQMC_Sim_Gtau(qmc, Gup, Gdn, i, j, sup, sdn)
        
        col = i
        row = i+j   
        if (row .gt. L) then
           row = row - L
        end if

        ri = (row-1)*N
        ci = (col-1)*N
        
        diff_up = DQMC_MatDiff(Nc, Gup(1:Nc,1:Nc), Gup1(ri+1:ri+Nc,ci+1:ci+Nc))
        diff_dn = DQMC_MatDiff(Nc, Gdn(1:Nc,1:Nc), Gdn1(ri+1:ri+Nc,ci+1:ci+Nc))
        print *, row, col, diff_up, diff_dn 
     end do
  end do
  call cpu_time(t3)

  print *, "Entire: ", t2-t1, " Block: ", t3-t2

  call DQMC_QMC_Free(qmc)

end program test5
