#include <exception>

class cuda_exception : public std::exception {
  char message[100];
  public:
    cuda_exception(const char *file, int line, int code);
    virtual const char* what() const throw();
};

#define CUDACHECK(a) { int code = (a); if (code) throw(cuda_exception(__FILE__, __LINE__, code)); }

void scalerow_gpu(int n, const double *h, const double *A, double *B);
void scalerowcol_gpu(int n, const double *h, double *A);
void cublas_dgemm(char transa, char transb,  int m, int n, int k, double alpha, double *a, int lda, double *b, int ldb, double beta, double *c, int ldc);
