program test1

  ! This program test the dqmc_simqmc module.

  use dqmc_simqmc
  implicit none

  ! parameters
  integer, parameter  :: L  = 12
  integer, parameter  :: Nx = 2
  integer, parameter  :: Ny = 2
  integer, parameter  :: Nc = Nx*Ny
  integer, parameter  :: Na = 2
  integer, parameter  :: n  = Nc*(Na+1)
  integer, parameter  :: nL = n*L
  integer, parameter  :: nWarm = 0
  integer, parameter  :: nPass = 0
  real(wp), parameter :: U = 2.0D0
  real(wp), parameter :: dtau = 0.125D0
  integer, parameter  :: seed = 12345    ! if seed=0, system seed will 
                                         ! be randomly generated

  ! variables
  type(simqmc) :: qmc
  real(wp)     :: K(n,n), tmp(n), sup, sdn
  real(wp)    :: Gup(n*L,n*L), Gdn(n*L,n*L)
  integer      :: i, j, ix, iy, il, b

  ! executables

  ! read K from Kmatrix.dat
  open(unit=10, file="Kmatrix.dat")
  do i = 1,n
     read(10, *) tmp
     K(i,:) = -tmp
  end do

  ! initialize qmc simulator
  call DQMC_QMC_Init(qmc, Nc, Na, L, U, dtau, K, nwarm, npass, seed)
  
  ! Warmup sweep    
  do i = 1, qmc%Hub%nWarm
     ! The second parameter means no measurement should be made.
     call DQMC_Hub_Sweep(qmc%Hub, NO_MEAS0)
     call DQMC_Hub_Sweep2(qmc%Hub, qmc%Hub%nTry)
  end do

  ! Loop here
  ! measurement sweep    
  do i = 1, qmc%Hub%nPass
     ! The second parameter means no measurement should be made.
     call DQMC_Hub_Sweep(qmc%Hub, NO_MEAS0)
     call DQMC_Hub_Sweep2(qmc%Hub, qmc%Hub%nTry)
  end do
  
  ! Get Green's function
  call DQMC_measure(qmc, Gup, Gdn, sup, sdn)

  do il = 1, L
     b = (il-1)*N
     do j=1,Nc
        do i=1,Nc   
           write(*,*) i, j, il, Gup(b+i,2*N+j)
        end do
     end do
  end do
  
end program test1
