program dqmc_test
  ! This program checks the execution time for
  ! QUEST on a 2-dimensional PEriodic Reactangular
  ! Lattice (2DPERL)

  use DQMC_Cfg
  use DQMC_Hubbard
  implicit none

  real          :: t1, t2
  type(Config)  :: cfg
  type(Hubbard) :: Hub
  character(len=slen) :: gfile
  logical       :: valid

  call cpu_time(t1)  
  
  ! Read input file
  call DQMC_Read_Config(cfg, STDIN)
   
  ! Initialize geometry
  call CFG_Get(cfg, "gfile", gfile)
  call DQMC_Geom_Read_Def(Hub%S, gfile)
  
  ! Initialize the rest data
  call DQMC_Hub_Config(Hub, cfg)
  
  ! Execution MC loop
  call DQMC_Hub_Run(Hub)
  
  ! Print computed results
  call DQMC_Hub_Print(Hub, STDOUT)
  
  ! Clean up the used storage
  call DQMC_Hub_Free(Hub)
  call DQMC_Config_Free(cfg)
  
  call cpu_time(t2)
  write(STDOUT,*) "Running time:",  t2-t1, "(second)"

end program dqmc_test
