program Test_Wrap

  use DQMC_WRAPPER1
  implicit none

  ! This program tests the module of wrapper functions.
  
  type(wrapper1)     :: wrap1
  real               :: t1, t2

  !================!
  ! Initialization !
  !================!
  call cpu_time(t1)
  
  ! read in other parameters
  call DQMC_Wrap1_Init(wrap1, STDIN)

  !================!
  !     Compute    !
  !================!
  call DQMC_Wrap1_Compute(wrap1)

  !================!
  ! Output results !
  !================!

  !! Output parameters and time dependent measurements
  call DQMC_Hub_Print(wrap1%Hub, STDOUT)
  !! Output time dependent measurements
  call DQMC_TDM_Postprocessing(wrap1%Tm, STDOUT)
  !! print out time
  call cpu_time(t2)
  write(STDOUT,*) "Running time:",  t2-t1, "(second)"
  
  ! Clean up
  call DQMC_Wrap1_Free(wrap1)

end program Test_Wrap

