module DQMC_WSpace

  use DQMC_UTIL
  use LAPACK_MOD
  use BLAS_MOD

  implicit none 
  
  ! 
  ! This module is used for memory mangement.
  !
  ! Data Type
  ! =========
  !
  type WSpace
     real(wp), pointer :: R1(:,:), R2(:,:), R3(:,:), R4(:,:)
     real(wp), pointer :: R5(:),   R6(:),   R7(:),   R8(:,:)
     integer,  pointer :: I1(:),   I2(:)
     integer :: lw(5)
  end type WSpace

  !
  ! Parameters
  ! ==========
  !
  integer, parameter  :: LA_SYEV   = 1     ! Index of LAPACK subroutines.
  integer, parameter  :: LA_GEQRF  = 2     ! This is used to specify 
  integer, parameter  :: LA_ORGQR  = 3     ! the size of working space.
  integer, parameter  :: LA_ORMQR  = 4     !  
  integer, parameter  :: LA_GETRI  = 5     !  

contains

  !---------------------------------------------------------------------!

  subroutine DQMC_WSpace_Allocate(n, mx_nbr, WS)
    !
    ! Purpose
    ! =======
    !    This subrotine allocates memory for MPool
    !
    ! Arguments
    ! =========
    !
    integer, intent(in)           :: n, mx_nbr  ! 
    type(WSpace), intent(inout)   :: WS         ! working space

    ! ... LAPACK subroutine
    integer  :: ILAENV

    ! ... Local scalar ...
    integer  :: nb, info

    ! ... Executable ....

    info = 0
    ! Initialize working space
    call DQMC_ReshapeR2(n, n, WS%R1)
    call DQMC_ReshapeR2(n, n, WS%R2)
    call DQMC_ReshapeR2(n, n, WS%R3)

    nb = max(n, mx_nbr)
    call DQMC_ReshapeR2(nb, nb, WS%R4)
    call DQMC_ReshapeR1(n, WS%R5)
    call DQMC_ReshapeR1(n, WS%R6)

    ! Get optimal block size for working space
    ! Part of codes are copied from LAPACK
    call dsyev('V', 'L', n, WS%R1, n, WS%R2, WS%R3, -1, info)
    WS%lw(LA_SYEV) = int(WS%R3(1,1)) 
!    nb = ILAENV( 1, "DSYEV",  "U", n, -1, -1, -1 )
!    WS%lw(LA_SYEV) = (nb+2)*n 
    nb = ILAENV( 1, "DGEQRF", " ", n,  n, -1, -1 )
    WS%lw(LA_GEQRF) = 2*n + (n+1)*nb
    nb = ILAENV( 1, "DORGQR", " ", n,  n,  n, -1 )
    WS%lw(LA_ORGQR) = n*nb    
    nb = ILAENV( 1, "DORMQR", "RN", n, n,  n, -1 )
    WS%lw(LA_ORMQR) = n*nb
    nb = ILAENV( 1, "DGETRI", " ", n, -1, -1, -1 )
    WS%lw(LA_GETRI) = n*nb
    
    nb = maxval(WS%lw)
    call DQMC_ReshapeR1(nb, WS%R7)
    call DQMC_ReshapeR2(n, n, WS%R8)
    
    call DQMC_ReshapeI1(n, WS%I1)
    call DQMC_ReshapeI1(n, WS%I2)

  end subroutine DQMC_WSpace_Allocate

  !---------------------------------------------------------------------!
  
  subroutine DQMC_WSpace_Free(WS)
    !
    ! Purpose
    ! =======
    !    This subrotine frees working space
    !
    ! Arguments
    ! =========
    !
    type(WSpace), intent(inout)   :: WS         ! working space

    ! ... Executable ....

    call DQMC_Free(WS%R1)
    call DQMC_Free(WS%R2)
    call DQMC_Free(WS%R3)
    call DQMC_Free(WS%R4)
    call DQMC_Free(WS%R5)
    call DQMC_Free(WS%R6)
    call DQMC_Free(WS%R7)
    call DQMC_Free(WS%R8)
    call DQMC_Free(WS%I1)
    call DQMC_Free(WS%I2)

  end subroutine DQMC_WSpace_Free

end module DQMC_Wspace
