// cvqekmeans.c
// Evan Lord
// Created: July 24, 2007
// Last Modified: July 24, 2007


#include <stdlib.h>
#include <stdio.h>
#include "constants.h"
#include "struct_def.h"


float Distance(float *, float *, int);


// This function updates the closest clusters array (h(i)).  It receives the DATA struct
// and uses the cluster centroid coordinates to update h(i).

void UpdateClosestClusters(struct DATA * data)
{
  // loop counters
  int int_loop_one;
  int int_loop_two;

  int int_closest_cluster;       // current closest cluster to a given cluster
  int int_next_cluster;          // next cluster to look at

  float flt_shortest_distance;  // shortest distance between a give cluster and all others
  float flt_distance;           // distance between two cluster centroids

  // loop through all clusters
  for(int_loop_one = 0; int_loop_one < data->int_num_clusters; int_loop_one++){

    // initially set the closest cluster to be the next cluster in the cluster centroid array
    int_closest_cluster = (int_loop_one + 1) % data->int_num_clusters;
    // calculate the Euclidean distance between those two clusters
    flt_shortest_distance = Distance(data->cluster_centroids[int_loop_one], data->cluster_centroids[int_closest_cluster], data->int_dimensions);

    // loop through all remaining clusters
    for(int_loop_two = 2; int_loop_two < data->int_num_clusters; int_loop_two++){

      // get the index of the next cluster
      int_next_cluster = (int_loop_one + int_loop_two) % data->int_num_clusters;
      // calculate the distance between the two clusters
      flt_distance = Distance(data->cluster_centroids[int_loop_one], data->cluster_centroids[int_next_cluster], data->int_dimensions);
 
      // store the shortest distance and closest cluster
      if(flt_distance < flt_shortest_distance){
	flt_shortest_distance = flt_distance;     // update the shortest distance to cluster centroid
	int_closest_cluster = int_next_cluster;   // retain the cluster number of the closest centroid
      }	
    }

    data->closest_clusters[int_loop_one] = int_closest_cluster;   // store result in h(i) array

  }
}


// This function updates the g(i) and g'(i) portions of the ML and CL arrays.  It receives
// a pointer to a reassigned "super point" and the DATA struct.

void UpdateConstraints(struct SUPER_POINT * reassigned, struct DATA * data)
{
  // loop counters
  int int_loop_one;
  int int_loop_two;
  int int_loop_three;

  int int_num_constraints;      // number of constraints in current constraints array
  
  int ** cur_array;             // pointer to either ML or CL constraints array
  
  struct DATA_POINT * cur_data_point;   // data point in "super point"
  
  cur_data_point = reassigned->head;    // start at first data point in "super point"
  while(cur_data_point != NULL){        // loop over all data points in "super point"
    
    // loop over ML and CL constraints arrays
    for(int_loop_one = 0; int_loop_one < 2; int_loop_one++){
      
      if(int_loop_one == 0){   // ML constraints array
	cur_array = data->ML_constraints_array;
	int_num_constraints = data->int_num_ML_constraints;
      }
      else{                    // CL constraints array
	cur_array = data->CL_constraints_array;
	int_num_constraints = data->int_num_CL_constraints;
      }
      
      // loop over first two columns of constraints array
      for(int_loop_two = 0; int_loop_two < 2; int_loop_two++){
	
	// loop over all constraints in array
	for(int_loop_three = 0; int_loop_three < int_num_constraints; int_loop_three++){
	  
	  // if the current data point is involved in a constraint
	  if(cur_data_point->int_index == cur_array[int_loop_three][int_loop_two]){

	    // update g(i) or g'(i)
	    cur_array[int_loop_three][int_loop_two + 2] = reassigned->int_cluster;
	  }	  
	}
      }
    }
    cur_data_point = cur_data_point->pSetNext;  // move to next data point in "super point"
  }
}
