// constraints.c
// Evan Lord
// Created: Aug. 17, 2007
// Last Modified: Aug. 17, 2007


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <mcheck.h>
#include "constants.h"
#include "struct_def.h"

void Constraints(char *, int, float, struct DATA *, char *);
float Distance(float *, float *, int);
void Normalize(struct DATA *);
void PrintData(struct DATA *);
void ReadData(char *, char *, struct DATA *);
void ReadNames(char *, struct DATA *);


int main(int argc, char * argv[])
{
  FILE * pSpecs;

  struct DATA * data;

  char constraint_type[6];
  
  int int_arg_one;
   
  float flt_arg_two;

  srand(time(0));

  // check for correct number of arguments
  if(argc != 5){
    fprintf(stderr, "\nUsage:\t%s <names file> <data file> <constraint specification file> <output file name>\n\n", argv[0]);
    exit(1);
  }

  // open constraint specification file for reading
  if((pSpecs = fopen(argv[3], "r")) == NULL){
    fprintf(stderr, "\nThe file \"%s\" could not be opened.  ", argv[1]);
    fprintf(stderr, "The program will now terminate.\n\n");
    exit(1);
  }
  else{
    // allocate memory for the DATA struct
    if((data = (struct DATA *)malloc(sizeof(struct DATA))) == NULL){
      fprintf(stderr, "\nMemory allocation error.  Closing program.\n\n");
      exit(1);
    }
    else{
      // call function to read names file
      ReadNames(argv[1], data);   
      
      // call function to read data file
      ReadData(argv[2], data->str_names, data);
      
      Normalize(data);
      
      fscanf(pSpecs, "%s\t%d\t%f\n", constraint_type, &int_arg_one, &flt_arg_two);
      Constraints(constraint_type, int_arg_one, flt_arg_two, data, argv[4]);
      
      while(!feof(pSpecs)){
	fscanf(pSpecs, "%s\t%d\t%f\n", constraint_type, &int_arg_one, &flt_arg_two);
	Constraints(constraint_type, int_arg_one, flt_arg_two, data, argv[4]);
      }
      
    }  
  }
  
  return 0;
}


void Constraints(char * constraint_type, int int_arg_one, float flt_arg_two, struct DATA * data, char * filename)
{
  FILE * pConstraints;

  int int_point_one;
  int int_point_two;
  int int_num_ML;
  int int_num_CL;
  int int_loop_one;
  int int_loop_two;

  // open file for writing constraints
  if((pConstraints = fopen(filename, "a")) == NULL){
    fprintf(stderr, "\nThe constraints file could not be created.  ");
    fprintf(stderr, "The program will now terminate.\n\n");
    exit(1);
  }

  if(!strcmp(constraint_type, "labels")){
    int_num_ML = 0;
    int_num_CL = 0;

    while((int_num_ML < int_arg_one) || (int_num_CL < flt_arg_two)){

      int_point_one = rand() % data->int_num_data_points;
      int_point_two = rand() % data->int_num_data_points;
      
      if((!strcmp(data->labels_array[int_point_one], data->labels_array[int_point_two])) && (int_point_one != int_point_two) && (int_num_ML < int_arg_one)){
	fprintf(pConstraints, "%d\t%d\t1\n", int_point_one, int_point_two);
	int_num_ML++;
	printf("%d %d\n", int_num_ML, int_arg_one);
      }
      else if((strcmp(data->labels_array[int_point_one], data->labels_array[int_point_two])) && (int_num_CL < flt_arg_two)){
	fprintf(pConstraints, "%d\t%d\t-1\n", int_point_one, int_point_two);
	int_num_CL++;
	printf("%d %f\n", int_num_CL, flt_arg_two);
      }
    }
  }
  else if(!strcmp(constraint_type, "mindia")){
    if(int_arg_one == 0){                       // multi-dimensional
      
    }
    else{                                       // one-dimensional
      
    }
  }
  else if(!strcmp(constraint_type, "maxdia")){
    if(int_arg_one == 0){                       // multi-dimensional
      for(int_loop_one = 0; int_loop_one < data->int_num_data_points; int_loop_one++){
	for(int_loop_two = int_loop_one + 1; int_loop_two < data->int_num_data_points; int_loop_two++){
	  printf("%d %d ", int_loop_one, int_loop_two);
	  if(Distance(data->data_array[int_loop_one], data->data_array[int_loop_two], data->int_dimensions) > flt_arg_two){
	    fprintf(pConstraints, "%d\t%d\t-1\n", int_loop_one, int_loop_two);
	    printf("CL constraint generated\n");
	  }
	  else{
	    printf("\n");
	  }
	}
      }
    }
    else{                                       // one-dimensional
      
    }
  }
  else if(!strcmp(constraint_type, "minsep")){
    if(int_arg_one == 0){                       // multi-dimensional
      for(int_loop_one = 0; int_loop_one < data->int_num_data_points; int_loop_one++){
	for(int_loop_two = int_loop_one + 1; int_loop_two < data->int_num_data_points; int_loop_two++){
	  printf("%d %d ", int_loop_one, int_loop_two);
	  if(Distance(data->data_array[int_loop_one], data->data_array[int_loop_two], data->int_dimensions) < flt_arg_two){
	    fprintf(pConstraints, "%d\t%d\t1\n", int_loop_one, int_loop_two);
	    printf("ML constraint generated\n");
	  }
	  else{
	    printf("\n");
	  }
	}
      }
    }
    else{                                       // one-dimensional
      
    }
  }
  else if(!strcmp(constraint_type, "maxsep")){
    if(int_arg_one == 0){                       // multi-dimensional
      
    }
    else{                                       // one-dimensional
      
    }
  }
  else if(!strcmp(constraint_type, "pivot")){

  }
  else if(!strcmp(constraint_type, "apart")){

  }
  else{
    
  }

  fclose(pConstraints);
}
