// struct_def.h
// Evan Lord
// Created: July 10, 2007
// Last Modified: July 10, 2007


// This structure contains all data needed to perform the K-Means algorithms.
struct DATA
{
  int int_num_clusters;          // number of clusters to be found in the data

  int int_algorithm_version;     // K-Means type
                                    // 0: normal 
                                    // 1: COP
                                    // 2: CVQE

  char * str_names;              // string read from the .names file
  int int_dimensions;            // number of dimensions of the data

  float ** data_array;          // 2D-array of data points
  int int_num_data_points;       // number of data points

  char ** labels_array;
  int * distinct_labels;
  int int_num_labels;

  int ** ML_constraints_array;   // 2D-array of ML constraints
  int ** CL_constraints_array;   // 2D-array of CL constraints
  int int_num_ML_constraints;    // number of ML constraints
  int int_num_ML_satisfied;
  int int_num_CL_constraints;    // number of CL constraints
  int int_num_CL_satisfied;

  struct SUPER_POINT *** ML_constraint_ptrs;
  struct SUPER_POINT *** CL_constraint_ptrs;

  //struct SUPER_POINT ** ML_constraint_ptrs_one;
  //struct SUPER_POINT ** ML_constraint_ptrs_two;
  //struct SUPER_POINT ** CL_constraint_ptrs_one;
  //struct SUPER_POINT ** CL_constraint_ptrs_two;

  struct CONSTRAINT *** ML_constraint_involvement;
  struct CONSTRAINT *** CL_constraint_involvement;
  struct CONSTRAINT *** SP_CL_constraints;

  float * maxes;                // maximum value for each dimension of the data
  float * mins;                 // minimum value for each dimension of the data
  
  float ** cluster_centroids;     // 2D-array of cluster centroid coordinates
  float ** super_point_centroids; // 2D-array of super point centroids

  int * closest_clusters;

  struct DATA_POINT ** cluster_assignments;  // array of head pointers to linked
                                             // lists of points assigned to each
                                             // cluster (normal K-Means)
  struct DATA_POINT * head_point;  // head pointer to linked list of
                                   // all data points

  struct SUPER_POINT ** clusters;         // array of head pointers to linked
                                          // lists of super points assigned to
                                          // each cluster (COP K-Means)
  struct SUPER_POINT * super_point_head;  // head pointer to linked list of
                                          // all super points
  int Kmax;
  int Kmin;

  float VQE;     // total vector quantization error for particular clustering
  float CVQE;    // total constrained VQE for particular clustering

  int ** dendrogram;
};


// This structure is used for making linked lists of data points.
struct DATA_POINT
{
  int int_index;      // index of the data point
  int int_cluster;    // cluster to which the data point belongs
  int int_set;        // connected component to which this point belongs
                      // based on ML constraints (COP K-Means only)

  struct DATA_POINT * pPrev;         // previous and next pointers for 
  struct DATA_POINT * pNext;         // linked list of all data points


  struct DATA_POINT * pClusterPrev;  // previous and next pointers for linked 
  struct DATA_POINT * pClusterNext;  // lists of points in each cluster 
                                     // (normal K-Means)

  struct DATA_POINT * pSetPrev;      // previous and next pointers for linked
  struct DATA_POINT * pSetNext;      // lists of all points in a connected component
                                     // (COP K-Means)
};


// This structure is used for making linked lists of "super points".
// "Super points" contain one or more data points and are used only
// in the COP-K-Means algorithm.
struct SUPER_POINT
{
  int int_super_point_num;    // index of the super point
  int int_cluster;            // cluster to which the super point belongs
  int int_weight;             // number of points belonging to the super point
  int int_constraint;

  struct DATA_POINT * head;   // head of linked list of data points contained
                              // within the super point
  struct DATA_POINT * tail;

  struct SUPER_POINT * pPrev; // previous and next pointers for
  struct SUPER_POINT * pNext; // linked list of all super points

  struct SUPER_POINT * pClusterPrev;  // previous and next pointers for linked 
  struct SUPER_POINT * pClusterNext;  // lists of super points in each cluster
};



struct CONSTRAINT
{
  int int_constraint_index;
  int int_constraint_col;

  int int_other_point;
  
  struct CONSTRAINT * pNext;
};

