/*
 * Decompiled with CFR 0.152.
 */
package com.jdotsoft.jarloader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class JarClassLoader
extends ClassLoader {
    public static final String KEY_LOGGER = "JarClassLoader.logger";
    public static final String CONSOLE = "console";
    private PrintStream logger;
    private List<JarFile> lstJarFile;
    private Set<File> hsNativeFile;
    private Map<String, Class<?>> hmClass;
    static int ______INIT;
    static int ______SHUTDOWN;
    static int ______ACCESS;
    static int ______OVERRIDE;
    static int ______HELPERS;

    public JarClassLoader() {
        this(ClassLoader.getSystemClassLoader());
    }

    public JarClassLoader(ClassLoader classLoader) {
        super(classLoader);
        String string = System.getProperty(KEY_LOGGER);
        if (string != null) {
            if (string.equals(CONSOLE)) {
                this.logger = System.out;
            } else {
                try {
                    this.logger = new PrintStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new RuntimeException("JarClassLoader: cannot create log file: " + fileNotFoundException);
                }
            }
        }
        this.hmClass = new HashMap();
        this.lstJarFile = new ArrayList<JarFile>();
        this.hsNativeFile = new HashSet<File>();
        String string2 = null;
        try {
            ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URL uRL = codeSource.getLocation();
            string2 = URLDecoder.decode(uRL.getFile(), "UTF-8");
            this.log("Loading from top JAR: %s", string2);
            this.loadJar(new JarFile(string2));
        }
        catch (IOException iOException) {
            this.log("Not a JAR: %s %s", string2, iOException.toString());
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                JarClassLoader.this.shutdown();
            }
        });
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                    try {
                        JarClassLoader.loadLookAndFeel();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new RuntimeException("Failure to load LaF " + propertyChangeEvent.getNewValue(), classNotFoundException);
                    }
                }
            }
        });
    }

    private File createTempFile(JarEntryInfo jarEntryInfo) throws JarClassLoaderException {
        byte[] byArray = JarClassLoader.getJarBytes(jarEntryInfo);
        try {
            File file = File.createTempFile(jarEntryInfo.getName() + ".", null);
            file.deleteOnExit();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.close();
            return file;
        }
        catch (IOException iOException) {
            throw new JarClassLoaderException("Cannot create temp file for " + jarEntryInfo.jarEntry, iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadJar(JarFile jarFile) {
        this.lstJarFile.add(jarFile);
        try {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || (string = jarEntry.getName().toLowerCase()).lastIndexOf(".jar") != string.length() - ".jar".length()) continue;
                JarEntryInfo jarEntryInfo = new JarEntryInfo(jarFile, jarEntry);
                File file = this.createTempFile(jarEntryInfo);
                this.log("Loading inner JAR: %s from temp file %s", jarEntryInfo.jarEntry, this.getFilename4Log(file));
                try {
                    this.loadJar(new JarFile(file));
                }
                catch (IOException iOException) {
                    throw new JarClassLoaderException("Cannot load inner JAR " + jarEntryInfo.jarEntry, iOException);
                    return;
                }
            }
        }
        catch (JarClassLoaderException jarClassLoaderException) {
            throw new RuntimeException("ERROR on loading InnerJAR: " + jarClassLoaderException.getMessageAll());
        }
    }

    private JarEntryInfo findJarEntry(String string) {
        for (JarFile jarFile : this.lstJarFile) {
            JarEntry jarEntry = jarFile.getJarEntry(string);
            if (jarEntry == null) continue;
            return new JarEntryInfo(jarFile, jarEntry);
        }
        return null;
    }

    private List<JarEntryInfo> findJarEntries(String string) {
        ArrayList<JarEntryInfo> arrayList = new ArrayList<JarEntryInfo>();
        for (JarFile jarFile : this.lstJarFile) {
            JarEntry jarEntry = jarFile.getJarEntry(string);
            if (jarEntry == null) continue;
            arrayList.add(new JarEntryInfo(jarFile, jarEntry));
        }
        return arrayList;
    }

    private JarEntryInfo findJarNativeEntry(String string) {
        String string2 = System.mapLibraryName(string);
        for (JarFile jarFile : this.lstJarFile) {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string3;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || (string3 = jarEntry.getName()).lastIndexOf(string2) != string3.length() - string2.length()) continue;
                return new JarEntryInfo(jarFile, jarEntry);
            }
        }
        return null;
    }

    private Class<?> findJarClass(String string) throws JarClassLoaderException {
        Class<?> clazz = this.hmClass.get(string);
        if (clazz != null) {
            return clazz;
        }
        String string2 = string.replace('.', '/') + ".class";
        JarEntryInfo jarEntryInfo = this.findJarEntry(string2);
        if (jarEntryInfo != null) {
            byte[] byArray = JarClassLoader.getJarBytes(jarEntryInfo);
            try {
                clazz = this.defineClass(string, byArray, 0, byArray.length);
            }
            catch (ClassFormatError classFormatError) {
                throw new JarClassLoaderException(null, classFormatError);
            }
        }
        if (clazz == null) {
            throw new JarClassLoaderException(string);
        }
        this.hmClass.put(string, clazz);
        return clazz;
    }

    private void shutdown() {
        for (JarFile jarFile : this.lstJarFile) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
        String string = System.getProperty("user.home") + File.separator + ".JarClassLoader";
        this.deleteOldNative(string);
        this.persistNewNative(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOldNative(String string) {
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                File file = new File(string2);
                if (!file.exists() || file.delete()) continue;
                this.hsNativeFile.add(file);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistNewNative(String string) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (File file : this.hsNativeFile) {
                bufferedWriter.write(file.getCanonicalPath());
                bufferedWriter.newLine();
                file.delete();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isLaunchedFromJar() {
        return this.lstJarFile.size() > 0;
    }

    public String getManifestMainClass() {
        Attributes attributes = null;
        if (this.isLaunchedFromJar()) {
            try {
                Manifest manifest = this.lstJarFile.get(0).getManifest();
                attributes = manifest.getMainAttributes();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return attributes == null ? null : attributes.getValue(Attributes.Name.MAIN_CLASS);
    }

    public void invokeMain(String string, String[] stringArray) throws Throwable {
        Class<?> clazz = this.loadClass(string);
        this.log("Launch: %s.main(); Loader: %s", string, clazz.getClassLoader());
        Method method = clazz.getMethod("main", String[].class);
        boolean bl = false;
        boolean bl2 = false;
        if (method != null) {
            method.setAccessible(true);
            int n = method.getModifiers();
            bl = Modifier.isPublic(n) && Modifier.isStatic(n);
            Class<?> clazz2 = method.getReturnType();
            boolean bl3 = bl2 = clazz2 == Void.TYPE;
        }
        if (method == null || !bl || !bl2) {
            throw new NoSuchMethodException("The main() method in class \"" + string + "\" not found.");
        }
        try {
            method.invoke(null, new Object[]{stringArray});
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected synchronized Class<?> loadClass(String var1_1, boolean var2_2) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public URL getResource(String string) {
        if (this.isLaunchedFromJar()) {
            JarEntryInfo jarEntryInfo = this.findJarEntry(string);
            return jarEntryInfo == null ? null : jarEntryInfo.getURL();
        }
        return this.getParent().getResource(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        if (this.isLaunchedFromJar()) {
            List<JarEntryInfo> list = this.findJarEntries(string);
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (JarEntryInfo jarEntryInfo : list) {
                URL uRL = jarEntryInfo.getURL();
                if (uRL == null) continue;
                arrayList.add(uRL);
            }
            return Collections.enumeration(arrayList);
        }
        return this.getParent().getResources(string);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        if (this.isLaunchedFromJar()) {
            JarEntryInfo jarEntryInfo = this.findJarEntry(string);
            if (jarEntryInfo != null) {
                try {
                    return jarEntryInfo.jarFile.getInputStream(jarEntryInfo.jarEntry);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
        return this.getParent().getResourceAsStream(string);
    }

    @Override
    protected String findLibrary(String string) {
        JarEntryInfo jarEntryInfo = this.findJarNativeEntry(string);
        if (jarEntryInfo != null) {
            try {
                File file = this.createTempFile(jarEntryInfo);
                this.log("Loading native library: %s from temp file %s", jarEntryInfo.jarEntry, this.getFilename4Log(file));
                this.hsNativeFile.add(file);
                return file.getAbsolutePath();
            }
            catch (JarClassLoaderException jarClassLoaderException) {
                this.log("Failure to load native library %s: %s", string, jarClassLoaderException.toString());
            }
        }
        return null;
    }

    private static byte[] getJarBytes(JarEntryInfo jarEntryInfo) throws JarClassLoaderException {
        FilterInputStream filterInputStream = null;
        byte[] byArray = null;
        try {
            long l = jarEntryInfo.jarEntry.getSize();
            if (l <= 0L || l >= Integer.MAX_VALUE) {
                throw new JarClassLoaderException("Invalid size " + l + " for entry " + jarEntryInfo.jarEntry);
            }
            byArray = new byte[(int)l];
            InputStream inputStream = jarEntryInfo.jarFile.getInputStream(jarEntryInfo.jarEntry);
            filterInputStream = new DataInputStream(inputStream);
            ((DataInputStream)filterInputStream).readFully(byArray);
        }
        catch (IOException iOException) {
            throw new JarClassLoaderException(null, iOException);
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byArray;
    }

    public static void loadLookAndFeel() throws ClassNotFoundException {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel == null) {
            return;
        }
        ClassLoader classLoader = lookAndFeel.getClass().getClassLoader();
        if (classLoader == null) {
            return;
        }
        if (classLoader.getClass().getName().equals(JarClassLoader.class.getName())) {
            UIDefaults uIDefaults = UIManager.getDefaults();
            Enumeration enumeration = uIDefaults.keys();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string = (String)enumeration.nextElement();
                if (!string.endsWith("UI") || !((object = uIDefaults.get(string)) instanceof String)) continue;
                Class<?> clazz = classLoader.loadClass((String)object);
                uIDefaults.put(clazz.getName(), clazz);
            }
        }
    }

    private String getFilename4Log(File file) {
        if (this.logger != null) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private void log(String string, Object ... objectArray) {
        if (this.logger != null) {
            this.logger.printf("JarClassLoader: " + string + "\n", objectArray);
        }
    }

    private static class JarClassLoaderException
    extends Exception {
        private static final long serialVersionUID = -2509465264683924345L;

        JarClassLoaderException(String string) {
            super(string);
        }

        JarClassLoaderException(String string, Throwable throwable) {
            super(string, throwable);
        }

        String getMessageAll() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Throwable throwable = this; throwable != null; throwable = throwable.getCause()) {
                String string;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" / ");
                }
                if ((string = throwable.getMessage()) == null || string.length() == 0) {
                    string = throwable.getClass().getSimpleName();
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
    }

    private static class JarEntryInfo {
        JarFile jarFile;
        JarEntry jarEntry;

        JarEntryInfo(JarFile jarFile, JarEntry jarEntry) {
            this.jarFile = jarFile;
            this.jarEntry = jarEntry;
        }

        URL getURL() {
            try {
                return new URL("jar:file:" + this.jarFile.getName() + "!/" + this.jarEntry);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }

        String getName() {
            return this.jarEntry.getName().replace('/', '_');
        }

        public String toString() {
            return "JAR: " + this.jarFile.getName() + " ENTRY: " + this.jarEntry;
        }
    }
}

