#!/bin/sh

if [ $# -ne 9 ]; then
	echo Usage: ./assign_hybrid_expression_patterns.sh ref_parent_statistics_per_locus_file_array other_parent_statistics_per_locus_file_array hybrid_statistics_per_locus_file_array filtered_loci_file fold_change_threshold pvalue_threshold method number_of_points_to_sample hybrid_expression_pattern_output_directory
	exit
fi

ref_parent_statistics_per_locus_file_array=$1
other_parent_statistics_per_locus_file_array=$2
hybrid_statistics_per_locus_file_array=$3
filtered_loci_file=$4
fold_change_threshold=$5
pvalue_threshold=$6
method=$7
number_of_points_to_sample=$8
hybrid_expression_pattern_output_directory=$9

mkdir $hybrid_expression_pattern_output_directory

arguments_file=assign.hybrid.expression.patterns.arguments.file
rm -f $arguments_file
touch $arguments_file
echo $ref_parent_statistics_per_locus_file_array >> $arguments_file
echo $other_parent_statistics_per_locus_file_array >> $arguments_file
echo $hybrid_statistics_per_locus_file_array >> $arguments_file
echo $filtered_loci_file >> $arguments_file
echo $fold_change_threshold >> $arguments_file
echo $pvalue_threshold >> $arguments_file
echo $method >> $arguments_file
echo $number_of_points_to_sample >> $arguments_file
echo $hybrid_expression_pattern_output_directory >> $arguments_file

R CMD BATCH assign.hybrid.expression.patterns.R
