#!/usr/bin/env python

import sys

if len(sys.argv) != 4:
	raise IOError, 'Usage: ./filter_loci_by_genome_mapping_bias_ratio.py genome_mapping_bias_ratio_file mapping_bias_ratio_threshold filtered_loci_output_file'

def main(genome_mapping_bias_ratio_filename, mapping_bias_ratio_threshold_string, filtered_loci_output_filename):
	mapping_bias_ratio_threshold = float(mapping_bias_ratio_threshold_string)
	
	filtered_loci_output_file = open(filtered_loci_output_filename, 'w')
	genome_mapping_bias_ratio_file = open(genome_mapping_bias_ratio_filename, 'r')
	for line in genome_mapping_bias_ratio_file:
		line = line.rstrip('\n\r')
		field_list = line.split('\t')
		if len(field_list) != 2:
			raise IOError, "in filter_loci_by_genome_mapping_bias_ratio.py: expected two tab-delimited fields per line of genome_mapping_bias_ratio_file"
		locus = field_list[0]
		genome_mapping_bias_ratio_string = field_list[1]
		if genome_mapping_bias_ratio_string == 'NA':
			continue
		genome_mapping_bias_ratio = float(genome_mapping_bias_ratio_string)
		if genome_mapping_bias_ratio >= mapping_bias_ratio_threshold:
			filtered_loci_output_file.write('%s\n' % locus)
	genome_mapping_bias_ratio_file.close()
	filtered_loci_output_file.close()

	return

main(sys.argv[1], sys.argv[2], sys.argv[3])
