# get.genome.mapping.bias.R

library(hash)
source("statistics.per.locus.file.helper.functions.R")

"get.genome.mapping.bias" <- function(statistics.per.locus.directory, output.directory, query.sequence.name.array){
	output.file = paste(output.directory, '/', 'read.mapping.information.txt', sep='')
	print.read.mapping.information.to.output.file(statistics.per.locus.directory, query.sequence.name.array, output.file)
}

"print.read.mapping.information.to.output.file" <- function(statistics.per.locus.directory, query.sequence.name.array, output.file){
	cat("query.sequence.name\tbest.locus\tnum.reads.mapping.to.any.locus\tnum.reads.mapping.to.best.locus\n", file=output.file, append=FALSE)
	locus.array <- NULL
	num.query.sequences <- length(query.sequence.name.array)
	for(query.sequence.index in 1:num.query.sequences){
		query.sequence.name <- query.sequence.name.array[query.sequence.index]
		statistics.per.locus.file <- paste(statistics.per.locus.directory, '/', query.sequence.name, '_statistics_per_locus.txt', sep='')
		data <- read.statistics.per.locus.file(statistics.per.locus.file)
		locus.array <- data$locus.array
		read.count.array <- data$read.count.array
		num.loci <- length(locus.array)
		if(num.loci != 0){
			num.reads.mapping.to.any.locus <- sum(read.count.array)
			num.reads.mapping.to.best.locus <- NA
			best.locus <- NA
			for(i in 1:num.loci){
				current.locus <- locus.array[i]
				num.reads.mapping.to.current.locus <- read.count.array[i]
				if(is.na(best.locus) || (num.reads.mapping.to.current.locus > num.reads.mapping.to.best.locus)){
					best.locus <- current.locus
					num.reads.mapping.to.best.locus <- num.reads.mapping.to.current.locus
				}
			}
			if(is.na(best.locus)){
				stop("Internal error")
			}
			best.locus.string <- best.locus
		}else{
			best.locus.string <- ""
			num.reads.mapping.to.any.locus <- 0
			num.reads.mapping.to.best.locus <- 0
		}
		cat(sprintf("%s\t%s\t%d\t%d\n", query.sequence.name, best.locus.string, num.reads.mapping.to.any.locus, num.reads.mapping.to.best.locus), file=output.file, append=TRUE)
	}
}

argument.array <- as.matrix(read.table("get.genome.mapping.bias.arguments.file"))
if(length(argument.array) < 3){
	stop("Usage: Expected at least 3 arguments (each on a separate line): statistics.per.locus.directory output.directory query.sequence.name.1 [ query.sequence.name.2 . . . ]")
}

get.genome.mapping.bias(argument.array[1], argument.array[2], argument.array[3:length(argument.array)])
