#!/usr/bin/env python
# get_SNPs_for_read__module.py

def get_SNP_breakdown_for_read(chromosome, read_start_position, read_length, read_string, CIGAR_string, SNP_dict, SNP_to_refbase_dict, SNP_to_base_change_dict):
	position_in_read_to_junction_offset_dict = get_position_in_read_to_junction_offset_dict_from_CIGAR_string(CIGAR_string)

	num_ref_genome_SNPs_for_read, num_other_genome_SNPs_for_read, num_unexpected_SNPs_for_read = 0, 0, 0
	for i in range(0, read_length):
		position_in_read = i+1
		position = read_start_position + i + position_in_read_to_junction_offset_dict[position_in_read]
		## if the current base call covers a SNP
		if (chromosome in SNP_dict) and (position in SNP_dict[chromosome]):
			base_call = read_string[i]
			## and if it is not an 'N' base call
			if base_call in ['A', 'C', 'G', 'T']:
				## then count it
				if base_call == SNP_to_refbase_dict[chromosome][position]:
					num_ref_genome_SNPs_for_read += 1
				elif base_call == SNP_to_base_change_dict[chromosome][position]:
					num_other_genome_SNPs_for_read += 1
				else:
					num_unexpected_SNPs_for_read += 1
	return num_ref_genome_SNPs_for_read, num_other_genome_SNPs_for_read, num_unexpected_SNPs_for_read

def get_position_in_read_to_junction_offset_dict_from_CIGAR_string(CIGAR_string):
	position_in_read_to_junction_offset_dict = {}
	
	junction_offset = 0
	next_matching_position = 1
	last_index_of_prev_element = -1
	for i in range(0, len(CIGAR_string)):
		if CIGAR_string[i] == 'M':
			subalignment_length = int(CIGAR_string[(last_index_of_prev_element+1):i])
			for position_in_read in range(next_matching_position, next_matching_position + subalignment_length):
				position_in_read_to_junction_offset_dict[position_in_read] = junction_offset
			next_matching_position += subalignment_length
			last_index_of_prev_element = i
		elif CIGAR_string[i] == 'N':
			junction_offset += int(CIGAR_string[(last_index_of_prev_element+1):i])
			last_index_of_prev_element = i
		elif CIGAR_string[i] in ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9']:
			'do nothing'
		else:
			raise IOError, 'In get_position_in_read_to_junction_offset_dict_from_CIGAR_string(): CIGAR_string character \'%s\' cannot currently be handled by the code' % \
					CIGAR_string[i]
	return position_in_read_to_junction_offset_dict
