#!/usr/bin/env python
import sys

def get_locus_dict_from_file(locus_filename):
	locus_file = open(locus_filename, 'r')
	locus_dict = {}
	repeated_loci = False
	for line in locus_file:
		locus = line.strip()
		if locus in locus_dict:
			repeated_loci = True
			#print 'DEBUG: repeated_locus = %s' % locus
		locus_dict[locus] = 0
	locus_file.close()
	if repeated_loci:
		print 'Warning: Found at least one repeated locus in locus file'
	return locus_dict

def get_locus_to_alias_dict(locus_to_alias_filename):
	locus_to_alias_dict = {}
	locus_to_alias_file = open(locus_to_alias_filename, 'r')
	for line in locus_to_alias_file:
		line = line.rstrip('\n\r')
		field_list = line.split('\t')
		if len(field_list) != 2:
			raise IOError, 'Expected locus to alias file to have exactly two tab-delimited fields on each line'
		locus = field_list[0]
		alias = field_list[1]
		locus_to_alias_dict[locus] = alias
	locus_to_alias_file.close()

	return locus_to_alias_dict

def get_alias_dict_from_locus_dict_and_locus_to_alias_dict(locus_dict, locus_to_alias_dict):
	alias_dict = {}
	num_loci_without_an_alias = 0
	for locus in locus_dict:
		if locus in locus_to_alias_dict:
			alias = locus_to_alias_dict[locus]
			if alias in alias_dict:
				print 'Warning: Found two loci in locus list that have same alias (%s)' % alias
			alias_dict[alias] = 0
		else:
			num_loci_without_an_alias += 1
	if num_loci_without_an_alias != 0:
		print 'Warning: Found %d loci in locus file that have no alias' % num_loci_without_an_alias
	return alias_dict


