#!/bin/sh

if [ $# -le 3 ]; then
	echo 'Usage: ./read_count_frequency_distribution.sh read_counts_per_locus_dir RCFD_output_file allele_specific_RCFD_output_file condition_1 [ condition_2 ... ]'
	exit
fi

read_counts_per_locus_dir=$1
RCFD_output_file=$2
allele_specific_RCFD_output_file=$3
argument_list=( ${*} )
index_of_first_condition_in_argument_list=3

arguments_file=read.count.frequency.distribution.arguments.file
rm -f $arguments_file
touch $arguments_file

echo ${RCFD_output_file} >> $arguments_file
echo ${allele_specific_RCFD_output_file} >> $arguments_file

i=${index_of_first_condition_in_argument_list}
while [ $i -ne ${#argument_list[*]} ]; do
	condition=${argument_list[i]}
	stats_for_locus_files_for_condition=( `ls ${read_counts_per_locus_dir}/${condition}_*_statistics_per_locus` )
	if [ ${#stats_for_locus_files_for_condition[*]} -eq 0 ]; then
		echo Error: Could not find any read counts per locus files for condition ${condition} in specified directory
		exit
	fi
	condition_and_stats_for_locus_files_for_condition_string=${condition}
	for stats_for_locus_file in ${stats_for_locus_files_for_condition[*]}; do
		condition_and_stats_for_locus_files_for_condition_string=${condition_and_stats_for_locus_files_for_condition_string},${stats_for_locus_file}
	done
	echo ${condition_and_stats_for_locus_files_for_condition_string} >> ${arguments_file}
	i=$(( i + 1 ))
done

R CMD BATCH read.count.frequency.distribution.R

