#!/usr/bin/env python
import sys
from chromosome_helper_functions__module import *

def get_SNP_data(SNP_filename):
	SNP_dict, SNP_to_base_change_dict, SNP_to_refbase_dict = {}, {}, {}
	SNP_file = open(SNP_filename, 'r')
	SNPs_to_remove_dict = {}
	for line in SNP_file:
		line = line.rstrip('\n\r')
		field_list = line.split('\t')
		chromosome = get_base_chromosome_name(field_list[0])
		position_string = field_list[1]
		refbase = field_list[2]
		base_change = field_list[3]

		position_string = position_string.lower()
		if (position_string == 'pos') or (position_string == 'position'):
			# header line
			continue
		position = int(position_string)
		if not (chromosome in SNP_dict):
			SNP_dict[chromosome] = {}
			SNP_to_refbase_dict[chromosome] = {}
			SNP_to_base_change_dict[chromosome] = {}
		if position in SNP_dict[chromosome]:
			ERROR_file = open('__ERROR_LOG', 'a')
			ERROR_file.write('Found two SNPs at position %d of chromosome %s\n' % (position, chromosome))
			if refbase != SNP_to_refbase_dict[chromosome][position]:
				ERROR_file.write('Unexpected: Found two conflicting refbases for SNPs assigned to position %d of chromosome %s: %s and %s\n' % \
						(position, chromosome, refbase, SNP_to_refbase_dict[chromosome][position]))
			ERROR_file.close()
			if not (chromosome in SNPs_to_remove_dict):
				SNPs_to_remove_dict[chromosome] = {}
			SNPs_to_remove_dict[chromosome][position] = 0
		SNP_dict[chromosome][position] = 0
		SNP_to_refbase_dict[chromosome][position] = refbase
		SNP_to_base_change_dict[chromosome][position] = base_change
	SNP_file.close()

	## delete positions that are predicted to have two distinct SNPs
	for chromosome in SNPs_to_remove_dict:
		for position in SNPs_to_remove_dict[chromosome]:
			del SNP_dict[chromosome][position]
			del SNP_to_refbase_dict[chromosome][position]
			del SNP_to_base_change_dict[chromosome][position]

	return SNP_dict, SNP_to_refbase_dict, SNP_to_base_change_dict


