# upper.quartile.normalization.R

"get.upper.quartile.read.counts.for.multiple.read.count.arrays" <- function(array.of.read.count.arrays){
	num.arrays <- dim(array.of.read.count.arrays)[1]
	if(num.arrays == 0){
		stop("In get.upper.quartile.read.counts.for.multiple.read.count.arrays: expected array.of.read.count.arrays to contain at least one read count array")
	}
	if(num.arrays >= 2){
		for(i in 2:num.arrays){
			if(length(array.of.read.count.arrays[i-1,]) != length(array.of.read.count.arrays[i,])){
				stop(sprintf("read count arrays of different lengths: %d and %d\n", length(array.of.read.count.arrays[i-1,]), length(array.of.read.count.arrays[i,])))
			}
		}
	}
	total.number.of.loci <- length(array.of.read.count.arrays[1,])
	
	#matrix(NA, nrow=num.arrays, ncol=total.number.of.loci)
	zero.count.mask <- array(TRUE, dim=total.number.of.loci)
	for(i in 1:num.arrays){
		zero.count.mask.for.current.array <- (array.of.read.count.arrays[i,] == 0)
		zero.count.mask[!zero.count.mask.for.current.array] <- FALSE
	}

	subset.length <- length(zero.count.mask[!zero.count.mask])
	upper.quartile.index <- round(0.75 * (subset.length - 1)) + 1

	array.of.upper.quartile.read.counts <- array(NA, dim=num.arrays)
	for(i in 1:num.arrays){
		current.read.count.array.subset <- array.of.read.count.arrays[i,!zero.count.mask]
		current.read.count.array.subset.sorted <- sort(current.read.count.array.subset)
		array.of.upper.quartile.read.counts[i] <- current.read.count.array.subset.sorted[upper.quartile.index]
	}

	cat(sprintf("DEBUG: upper.quartile.index: %d subset.length: %d\n", upper.quartile.index, subset.length))

	array.of.upper.quartile.read.counts
}

