#!/usr/bin/env python

import sys
if len(sys.argv) != 3:
	raise IOError, 'Usage: ./vcf2SNP.py vcf_filename output_filename'

def main(vcf_filename, output_filename):
	output_file = open(output_filename, 'w')
	vcf_file = open(vcf_filename, 'r')
	output_file.write('sequence\tpos\trefbase\tSNPbase\n')
	for line in vcf_file:
		line = line.rstrip('\n\r')
		if (line == '') or (line[0] == '#'):
			## empty line or header line
			continue
		field_list = line.split('\t')
		sequence = field_list[0]
		pos = int(field_list[1])
		refbase = field_list[3]
		SNPbase = field_list[4]
		if not (SNPbase in ['A', 'C', 'G', 'T']):
			## do not consider SNP if SNPbase is not A, C, G, or T
			continue

		output_file.write('%s\t%d\t%s\t%s\n' % (sequence, pos, refbase, SNPbase))
	vcf_file.close()
	output_file.close()
	return

main(sys.argv[1], sys.argv[2])
