/*
**
**  FACILITY:  University of California, Davis
**              Computer Science Department
**              Theory Lab
**
**  PROGRAM NAME:       XPARAL
**
**  MODULE DESCRIPTION:
**
**      This code determines the match, mismatch, in/del, and gap
**      counts and values for the align string alignment using
**      constant costs.
**
*/

#include "header.h"
#include "globals_s.h"

#include "noweights.h"


/****************************************************************/
/*                                                              */
/* Initializes the alignment counts and values for a            */
/* specified alignment.                                         */
/*                                                              */
/* Note -- the procedure that reads in the input alignment      */
/*         ensures that both strings are the same length,       */
/*         removes all space-against-space matches, and         */
/*         ensures that '[' and ']' are in both strings         */
/*         and align against each other.                        */
/*                                                              */
/****************************************************************/

void    analyze_alignment_c(    Funct   *align_fun)
{
    char        *align1_wk = align_fun->align1,
                *align1_end,
                *align2_wk = align_fun->align2,
                *align2_end;
    int         str_w_gap = 0;

    align_fun->match_ct = 0;
    align_fun->mis_ct = 0;
    align_fun->inordel_ct = 0;
    align_fun->gaps_ct = 0;
    align_fun->match_val = 0.0;
    align_fun->mis_val = 0.0;
    align_fun->inordel_val = 0.0;
    align_fun->gaps_val = 0.0;
    align_fun->is_2D_opt = 0;

/*
**  Skip to the first characters that count for this option.
*/
    if  (scoring_method == ENDGAPS_FREE)
    {
        if  (*align1_wk == ' ')
        {
            while (*align1_wk == ' ')
            {
                align1_wk++;
                align2_wk++;
            }
        }
        else if  (*align2_wk == ' ')
        {
            while (*align2_wk == ' ')
            {
                align1_wk++;
                align2_wk++;
            }
        }
    }
    else if  (scoring_method == LOCAL)
    {
    /*  Local  */
        while (*align1_wk != '[')
        {
            align1_wk++;
            align2_wk++;
        }
        align1_wk++;
        align2_wk++;
    }
    else if  (scoring_method == SUBSTRING_1_OF_2)
    {
        while (*align1_wk == ' ')
        {
            align1_wk++;
            align2_wk++;
        }
    }

/*
**  Now set the end pointers to the last characters that
**  count for this option.
*/
    align1_end = align1_wk;
    align2_end = align2_wk;
    while (*align1_end != '\0')
    {
        align1_end++;
        align2_end++;
    }
    align1_end--;
    align2_end--;

    if  (scoring_method == ENDGAPS_FREE)
    {
        if  (*align1_end == ' ')
        {
            while (*align1_end == ' ')
            {
                align1_end--;
                align2_end--;
            }
        }
        else if  (*align2_end == ' ')
        {
            while (*align2_end == ' ')
            {
                align1_end--;
                align2_end--;
            }
        }
    }
    else if  (scoring_method == LOCAL)
    {
        while (*align1_end != ']')
        {
            align1_end--;
            align2_end--;
        }
        align1_end--;
        align2_end--;
    }
    else if  (scoring_method == SUBSTRING_1_OF_2)
    {
        while (*align1_end == ' ')
        {
            align1_end--;
            align2_end--;
        }
    }

/*
**  Now align1_wk and align2_wk point at the start
**  of the alignment region and
**  align1_end and align2_end point at its end.
**
**  So now we analyze (count and value) the alignment.
*/
    while (align1_wk <= align1_end)
    {
        if  (   (*align1_wk != '[')
             && (*align1_wk != ']'))
        /*  We don't score the local alignment symbols  */
        {
            if  (*align1_wk == ' ')
            {
            /*  (*align2_wk != ' ') by the align procedure  */
                align_fun->inordel_ct++;
                align_fun->inordel_val += WEIGHT_INORDEL;
                if  (str_w_gap != 1)
                {
                    align_fun->gaps_ct++;
                    align_fun->gaps_val += WEIGHT_GAP;
                    str_w_gap = 1;
                }
            }
            else if  (*align2_wk == ' ')
            {
                align_fun->inordel_ct++;
                align_fun->inordel_val += WEIGHT_INORDEL;
                if  (str_w_gap != 2)
                {
                    align_fun->gaps_ct++;
                    align_fun->gaps_val += WEIGHT_GAP;
                    str_w_gap = 2;
                }
            }
            else  /*  => match or mismatch  */
            {
                str_w_gap = 0;
                if  (*align1_wk == *align2_wk)
/*              => match  */
                {
                    align_fun->match_ct++;
                    align_fun->match_val += WEIGHT_MATCH(*align1_wk, *align2_wk);
                }
                else
/*              => mismatch  */
                {
                    align_fun->mis_ct++;
                    align_fun->mis_val += WEIGHT_MISMATCH(*align1_wk, *align2_wk);
                }
            }
        }
        align1_wk++;
        align2_wk++;
    }
    if  (!with_gaps)
      align_fun->gaps_val = 0;
}

double  convex_indel_weight_c( int length )
{
  double ret_value;

  if (convex==1) {
    ret_value=length;
  }
  else if (convex==2) {
    ret_value=( (length) > 1 ) ? log(length) : log(1.5);
  }
  else if (convex==3) {
    ret_value=( 1.0 + log(length) );
  }
  else if (convex==4) {
    ret_value=log(length + 1.0 );
  }
  else if (convex==5) {
    ret_value=( sqrt(length) );
  }
  else if (convex==6) {
    ret_value=( 1.0 + sqrt(length) );
  }
  else if (convex==7) {
    ret_value=( sqrt(length+1.0) );
  }

  return -ret_value;
}

void    analyze_alignment_convex_c(    Funct   *align_fun)
{
    char        *align1_wk = align_fun->align1,
                *align1_end,
                *align2_wk = align_fun->align2,
                *align2_end;
    int         str_w_gap = 0,
		top_gap = 0,
		top_len = 0,
		side_len = 0,
		side_gap = 0;

    align_fun->match_ct = 0;
    align_fun->mis_ct = 0;
    align_fun->inordel_ct = 0;
    align_fun->gaps_ct = 0;
    align_fun->match_val = 0.0;
    align_fun->mis_val = 0.0;
    align_fun->inordel_val = 0.0;
    align_fun->gaps_val = 0.0;
    align_fun->is_2D_opt = 0;

/*
**  Skip to the first characters that count for this option.
*/
    if  (scoring_method == ENDGAPS_FREE)
    {
        if  (*align1_wk == ' ')
        {
            while (*align1_wk == ' ')
            {
                align1_wk++;
                align2_wk++;
            }
        }
        else if  (*align2_wk == ' ')
        {
            while (*align2_wk == ' ')
            {
                align1_wk++;
                align2_wk++;
            }
        }
    }
    else if  (scoring_method == LOCAL)
    {
    /*  Local  */
        while (*align1_wk != '[')
        {
            align1_wk++;
            align2_wk++;
        }
        align1_wk++;
        align2_wk++;
    }
    else if  (scoring_method == SUBSTRING_1_OF_2)
    {
        while (*align1_wk == ' ')
        {
            align1_wk++;
            align2_wk++;
        }
    }

/*
**  Now set the end pointers to the last characters that
**  count for this option.
*/
    align1_end = align1_wk;
    align2_end = align2_wk;
    while (*align1_end != '\0')
    {
        align1_end++;
        align2_end++;
    }
    align1_end--;
    align2_end--;

    if  (scoring_method == ENDGAPS_FREE)
    {
        if  (*align1_end == ' ')
        {
            while (*align1_end == ' ')
            {
                align1_end--;
                align2_end--;
            }
        }
        else if  (*align2_end == ' ')
        {
            while (*align2_end == ' ')
            {
                align1_end--;
                align2_end--;
            }
        }
    }
    else if  (scoring_method == LOCAL)
    {
        while (*align1_end != ']')
        {
            align1_end--;
            align2_end--;
        }
        align1_end--;
        align2_end--;
    }
    else if  (scoring_method == SUBSTRING_1_OF_2)
    {
        while (*align1_end == ' ')
        {
            align1_end--;
            align2_end--;
        }
    }

/*
**  Now align1_wk and align2_wk point at the start
**  of the alignment region and
**  align1_end and align2_end point at its end.
**
**  So now we analyze (count and value) the alignment.
*/
    side_len=0;
    side_gap=0;
    top_len=0;
    top_gap=0;

    while (align1_wk <= align1_end) {
        if  (   (*align1_wk != '[')
		&& (*align1_wk != ']')) {
	  /*  We don't score the local alignment symbols  */
	  if  (*align1_wk == ' ') {
	    if (side_gap) { /* just ended a side gap */
	      align_fun->gaps_ct++;
	      align_fun->gaps_val += WEIGHT_GAP_CONV;
	      align_fun->inordel_ct+=side_len;
	      align_fun->inordel_val += convex_indel_weight_c(side_len);
	      side_len=0;
	      side_gap=0;
	    }
	    top_gap=1;
	    top_len++;
	  }
	  else if  (*align2_wk == ' ') {
	    if (top_gap) { /* just ended a top gap */
	      align_fun->gaps_ct++;
	      align_fun->gaps_val += WEIGHT_GAP_CONV;  
	      align_fun->inordel_ct += top_len;
	      align_fun->inordel_val += convex_indel_weight_c(top_len);
	      top_len=0;
	      top_gap=0;
	    }
	    side_gap = 1;
	    side_len++;
	  }
          else { /*  => match or mismatch  */
	    if (side_gap) { /* just ended a side gap */
	      align_fun->gaps_ct++;
	      align_fun->gaps_val += WEIGHT_GAP_CONV;
	      align_fun->inordel_ct+=side_len;
	      align_fun->inordel_val += convex_indel_weight_c(side_len);
	      side_len=0;
	      side_gap=0;
	    }
	    if (top_gap) { /* just ended a top gap */
	      align_fun->gaps_ct++;
	      align_fun->gaps_val += WEIGHT_GAP_CONV;  
	      align_fun->inordel_ct += top_len;
	      align_fun->inordel_val += convex_indel_weight_c(top_len);
	      top_len=0;
	      top_gap=0;
	    }
	    if  (*align1_wk == *align2_wk) {
	      align_fun->match_ct++;
	      align_fun->match_val += WEIGHT_MATCH(*align1_wk, *align2_wk);
	    }
	    else {
	      align_fun->mis_ct++;
	      align_fun->mis_val += WEIGHT_MISMATCH(*align1_wk, *align2_wk);
	    }
	  }
        }
	align1_wk++;
	align2_wk++; 
    }
    if (side_gap) { /* just ended a side gap */
      align_fun->gaps_ct++;
      align_fun->gaps_val += WEIGHT_GAP_CONV;
      align_fun->inordel_ct+=side_len;
      align_fun->inordel_val += convex_indel_weight_c(side_len);
      side_len=0;
      side_gap=0;
    }
    if (top_gap) { /* just ended a top gap */
      align_fun->gaps_ct++;
      align_fun->gaps_val += WEIGHT_GAP_CONV;  
      align_fun->inordel_ct += top_len;
      align_fun->inordel_val += convex_indel_weight_c(top_len);
      top_len=0;
      top_gap=0;
    }
    if  (!with_gaps)
      align_fun->gaps_val = 0;
}

