/*
**++
**  FACILITY:  University of California, Davis
**              Computer Science Department
**              Theory Lab
**
**  PROGRAM NAME:       XPARAL
**
**  MODULE DESCRIPTION:
**
**      This file contains the routine that calls the appropriate
**      function for performing the dynamic string matching.
**      (Different routines are called for constant costs
**      than for costs from a weight table).
**
*/

#include "header.h"
#include "globals_s.h"
#include "dynam_conv.h"
extern void     calc_fun_from_path_c(Funct*);
extern void     calc_fun_from_path_w(Funct*);
extern void     calc_convex_fun_from_path_c(Funct*);
extern void     calc_convex_fun_from_path_w(Funct*);
extern Funct    *find_max_c(Point*, const int);
extern Funct    *find_max_w(Point*, const int);
extern Funct    *find_max_c_fast(Point*, const int);
extern Funct    *find_max_w_fast(Point*, const int);

/****************************************************************/
/* convex prototypes						*/
/****************************************************************/
void lpush(int i, int j, int *locsp, stpoint *locst);
stpoint lpop(int *locsp, stpoint *locst);
void get_first_align_path_convex( Max_node *array );
int get_next_align_path_convex( Max_node *array );
int get_prev_align_path_convex( Max_node *array );
int tracebacknext(int *lsp, stpoint *lst );
void tracebacklast(int n, int m, int *localsp, stpoint *localst );
int tracebackprev(int *lsp, stpoint *lst );
void tracebackfirst(int n, int m, int *localsp, stpoint *localst );
/****************************************************************/
/* Some more prototypes                                         */
/****************************************************************/
int found_next_start();
int found_prev_start();

/*
**  Access to the array
*/

#define access_mat(a,row,column)  ((a)+((row)*(len2+1))+(column))


/****************************************************************/
/*  fills the gap table with the function specified             */
/****************************************************************/

void   fill_gap_table(int a)
{
  int i;
  delete gap_size_weight;
//  gap_size_weight = (double *)malloc((a+2)*sizeof(double));
gap_size_weight = new double[a+2];
  if (convex==1) {
    for (i=1; i <= a+1; i++) {
      gap_size_weight[i]=GAP_FUNA(i);
    }
  }
  else if (convex==2) {
    for (i=1; i <= a+1; i++) {
      gap_size_weight[i]=GAP_FUNB(i);
    }
  }
  else if (convex==3) {
    for (i=1; i <= a+1; i++) {
      gap_size_weight[i]=GAP_FUNC(i);
    }
  }
  else if (convex==4) {
    for (i=1; i <= a+1; i++) {
      gap_size_weight[i]=GAP_FUND(i);
    }
  }
  else if (convex==5) {
    for (i=1; i <= a+1; i++) {
      gap_size_weight[i]=GAP_FUNE(i);
    }
  }
  else if (convex==6) {
    for (i=1; i <= a+1; i++) {
      gap_size_weight[i]=GAP_FUNF(i);
    }
  }
  else if (convex==7) {
    for (i=1; i <= a+1; i++) {
      gap_size_weight[i]=GAP_FUNG(i);
    }
  }
  max_gap_size=a;	
}

/****************************************************************/
/*  Calculates the number of distinct optimal alignments        */
/****************************************************************/

void    get_align_start_array_ij()
{
    Max_node    *curr,
                *test;
    int         i,
                j;

    if  (scoring_method == GLOBAL)
    {
        align_start_array_i = len1;
        align_start_array_j = len2;
        curr = access_mat(array, len1, len2);
        align_max_val = curr->value;
    }
    else if  (scoring_method == ENDGAPS_FREE)
    {
        align_start_array_i = i = len1;
        align_start_array_j = j = 0;
        curr = access_mat(array, i, j);
        align_max_val = curr->value;
        j++;
        test = curr + 1;
        while (j <= len2)
        {
            if  (test->value > align_max_val)
            {
                if  (!equal(test->value, align_max_val))
                {
                    align_start_array_i = i;
                    align_start_array_j = j;
                    curr = test;
                }
                align_max_val = test->value;
            }
            j++;
            test++;
        }
        i = len1 - 1;
        j = len2;
        test = access_mat(array, i, j);
        while (i >= 0)
        {
            if  (test->value > align_max_val)
            {
                if  (!equal(test->value, align_max_val))
                {
                    align_start_array_i = i;
                    align_start_array_j = j;
                    curr = test;
                }
                align_max_val = test->value;
            }
            i--;
            test -= (len2 + 1);
        }
    }
    else if  (scoring_method == LOCAL)
    {
        align_start_array_i = i = 0;
        align_start_array_j = j = 0;
        test = curr = access_mat(array, i, j);

        for (i = 0; i <= len1; i++)
        {
            for (j = 0; j <= len2; j++)
            {
                if  (test->value > curr->value)
                {
                    if  (!equal(test->value, align_max_val))
                    {
                        align_start_array_i = i;
                        align_start_array_j = j;
                        curr = test;
                    }
                    align_max_val = test->value;
                }
                test++;
            }
        }
    }
    else if  (scoring_method == SUBSTRING_1_OF_2)
    {
        align_start_array_i = i = len1;
        align_start_array_j = j = 0;
        curr = access_mat(array, i, j);
        j = 1;
        test = curr + 1;
        while (j <= len2)
        {
            if  (test->value > curr->value)
            {
                if  (!equal(test->value, align_max_val))
                {
                    align_start_array_j = j;
                    curr = test;
                }
                align_max_val = test->value;
            }
            j++;
            test++;
        }
    }
}

/*************************************************************/
/*************************************************************/
/* BEGIN: CONVEX TRACEBACK FUNCTIONS			     */
/*************************************************************/
/*************************************************************/


/***************************************************************************/
/* simple stack operations                                                 */
/***************************************************************************/


void lpush(int i, int j, int *locsp, stpoint *locst)
{
  locst[*locsp].i = i;
  locst[*locsp].j = j;
  (*locsp)++;
}

stpoint lpop(int *locsp, stpoint *locst)
{
  (*locsp)--;
  return locst[*locsp];
}


/***************************************************************************/
/* get_first_align_path_convex( Max_node        *array )		   */
/* generates first alignment for convex gaps				   */
/***************************************************************************/
void get_first_align_path_convex( Max_node        *array )
{
  Max_node    *curr;
  char        *align_path_wk;
  stpoint     *lst;
  int	 lsp;
  int         i,j,k,l,di,dj;
  
  get_align_start_array_ij();
  align_path_wk = align_path - 1;
  i = align_start_array_i;
  j = align_start_array_j;

  /* calculate alignment */
//  lst = (stpoint *)malloc((len1+len2+4)*sizeof(stpoint));
  lst = new stpoint[len1 + len2 + 4];
  lsp = 0;
  tracebackfirst(i,j,&lsp,lst);

  /* save local stack & pointer info to global */
  delete gst;
  gst=lst;
  gsp=lsp;
  
  /* calculate the alignment string from the stack */
  /* moving from largest point to 0,0 */
  for (k = 1; k < lsp; k++) {
    di=lst[k-1].i-lst[k].i;
    dj=lst[k-1].j-lst[k].j;
    if ( di==1 && dj==1 ) {
      /* came from diag */
      *align_path_wk++;
      *align_path_wk = DIAG;
    }
    else if ( di > 0 && dj == 0) {
      /* came from top */
      for (l=0; l<di; l++) {
	*align_path_wk++;
	*align_path_wk = UP;
      }
    }
    else {
      /* came from side */
      for (l=0; l<dj; l++) {
	*align_path_wk++;
	*align_path_wk = SIDE;
      }
    }
  }
  align_path_last = align_path_wk;
  *(align_path_last + 1) = '\0';
  align_number = 1;
}

/***************************************************************************/
/* get_next_align_path_convex( Max_node        *array )		           */
/* generates next alignment for convex gaps				   */
/***************************************************************************/
int get_next_align_path_convex( Max_node        *array )
{
  Max_node	*curr;
  char		*align_path_wk;
  stpoint	*lst;
  int		lsp;
  int		ret_val;
  int           got_a_new_start;
  int		i,j,k,l,di,dj;

  align_path_wk = align_path - 1;
  
  /* calculate next alignment */
  
  lst = gst;
  lsp = gsp;
  ret_val=tracebacknext(&lsp,lst); 
  gst=lst;
  gsp=lsp;
  /* may have exausted this starting point, if so find another */
  if ( ret_val==0 ) {
    got_a_new_start=found_next_start();
    if ( got_a_new_start ) {
      i = align_start_array_i;
      j = align_start_array_j;
      lsp = 0;
      tracebackfirst(i,j,&lsp,lst);
      gst=lst;
      gsp=lsp;
      ret_val=1;
    }
  }    
  if ( ret_val==1 ) {
    /* calculate the alignment string from the stack 	*/
    /* moving from largest point to 0,0		*/
    for (k = 1; k < lsp; k++) {
      di=lst[k-1].i-lst[k].i;
      dj=lst[k-1].j-lst[k].j;
      if ( di==1 && dj==1 ) {
	/* came from diag */
	*align_path_wk++;
	*align_path_wk = DIAG;
      }
      else if ( di > 0 && dj == 0) {
	/* came from top */
	for (l=0; l<di; l++) {
	  *align_path_wk++;
	  *align_path_wk = UP;
	}
      }
      else  {
	/* came from side */
	for (l=0; l < dj; l++) {
	  *align_path_wk++;
	  *align_path_wk = SIDE;
	}
      }
    }
    align_end_array_i = 0;
    align_end_array_j = 0;
    align_path_last = align_path_wk;
    *(align_path_last + 1) = '\0';
    align_number++;
    return 1;
  }
  else {
    return 0;
  }
}

/***************************************************************************/
/* get_prev_align_path_convex( Max_node        *array )		           */
/* generates prev alignment for convex gaps				   */
/***************************************************************************/
int get_prev_align_path_convex( Max_node        *array )
{
  Max_node	*curr;
  char		*align_path_wk;
  stpoint	*lst;
  int		lsp;
  int		ret_val;
  int		got_a_new_start;
  int		i,j,k,l,di,dj;

  align_path_wk = align_path - 1;
  
  /* calculate prev alignment */
  lst = gst;
  lsp = gsp;
  ret_val=tracebackprev(&lsp,lst);
  gst=lst;
  gsp=lsp;

  if ( ret_val==0 ) {
    /* there may be another starting point */
    got_a_new_start=found_prev_start();
    if ( got_a_new_start ) {
      i = align_start_array_i;
      j = align_start_array_j;
      lsp = 0;
      tracebacklast(i,j,&lsp,lst);
      gst=lst;
      gsp=lsp;
      ret_val=1;
    }
  }
  if ( ret_val==1 ) {
    /* calculate the alignment string from the stack 	*/
    /* moving from largest point to 0,0		*/
    for (k = 1; k < lsp; k++) {
      di=lst[k-1].i-lst[k].i;
      dj=lst[k-1].j-lst[k].j;
      if ( di==1 && dj==1 ) {
	/* came from diag */
	*align_path_wk++;
	*align_path_wk = DIAG;
      }
      else if ( di > 0 && dj == 0) {
	/* came from top */
	for (l=0; l<di; l++) {
	  *align_path_wk++;
	  *align_path_wk = UP;
	}
      }
      else {
	/* came from side */
	for (l=0; l<dj; l++) {
	  *align_path_wk++;
	  *align_path_wk = SIDE;
	}
      }
    }
    align_end_array_i = 0;
    align_end_array_j = 0;
    align_path_last = align_path_wk;
    *(align_path_last + 1) = '\0';
    align_number--;
    return 1;
  }
  else {
    return 0;
  }
}


/***************************************************************************/
/* tracebacknext(pointer,stack): compute the next optimal traceback        */
/* returns 1 if successfull						   */
/* returns 0 if last trace						   */
/* returns -1 on error  						   */
/***************************************************************************/

int tracebacknext(int *lsp, stpoint *lst )
{
  int 		i, j, k, len;
  char		dir;
  stpoint 	p0, p1;
  double	side_val,test_val,top_val;
  Max_node 	*curr, *top, *side;
   
  while(1) {
    if ((*lsp)==1) {
      /* last trace */
      p0=lpop(lsp,lst);
      tracebacklast(p0.i, p0.j, lsp, lst);
      return 0;
    }
    p1=lpop(lsp,lst);
    p0=lpop(lsp,lst);
    lpush(p0.i, p0.j, lsp, lst);
    if ( (p0.i-p1.i) > 0 && (p0.j-p1.j) > 0) {
      /* from the diag */
      dir=DIAG;
      len=1;
     }
    else if ( (p0.i-p1.i) > 0 && (p0.j-p1.j)==0) {
      /* from the top */
      dir=UP;
      len=(p0.i-p1.i);
    }
    else {
      /* from the left */
      dir=SIDE;
      len=(p0.j-p1.j);
    }
    i=p0.i;
    j=p0.j;
    /* now check for possible coalignments */
    curr=access_mat(array,i,j);
    if (dir==SIDE) {
      /* first try for shorter gap */
      for (k=len-1; k>0; k--) {
	side=access_mat(array,i,j-k);
	test_val=side->value + (convex_y * WEIGHT_INORDEL_CONV(k) ) + ( convex_w * WEIGHT_GAP_CONV );
	/* test_val = v[i][j-k].val - gap_cost(k) */
	if ( equal( test_val, curr->value) ) {
	  tracebackfirst(i, j-k, lsp, lst);
	  return(1);
	}
      }
      /* then try for diag */
      if ( curr->path.flag.diag_opt ) {
	tracebackfirst(i-1,j-1,lsp,lst);
	return(1);
      }
      /* try for top */
      if ( curr->path.flag.top_opt ) {
	/* choose longest */
	tracebackfirst(curr->f_gap_start,j,lsp,lst);
	return(1);
      }
    }
    else if (dir==DIAG) {
      /* try for top */
      if ( curr->path.flag.top_opt ) {
	/* choose longest */
	tracebackfirst(curr->f_gap_start,j,lsp,lst);
	return(1);
      }
    }
    else { 
      /* Dir = UP */
      /* try for shorter gap */
      for (k=len-1; k>0; k--) {
	top=access_mat(array,i-k,j);
	test_val=top->value + (convex_y * WEIGHT_INORDEL_CONV(k) ) + ( convex_w * WEIGHT_GAP_CONV );
	/* test_val = v[i-k][j].val-gap_cost(k) */		
	if ( equal(test_val,curr->value) ) {
	  tracebackfirst(i-k, j, lsp, lst);
	  return(1);
	}
      }
    }
    /* cooptimal not found at current node go further up */
  }
}     

/***************************************************************************/
/* tracebacklast(n,m): compute the last optimal traceback                  */
/***************************************************************************/

void tracebacklast(int n, int m, int *localsp, stpoint *localst )
{
   int		i,j,k;
   double	side_val,test_val,top_val;
   Max_node 	*curr, *top, *side;

   i=n;
   j=m;
   while(1) {
ITR1:lpush(i,j,localsp,localst);
     curr=access_mat(array,i,j);
     if (i == 0 || j == 0 || (!curr->path.flags) ) {
	  /* stop recursion and output alignment */
          align_end_array_i = i;
          align_end_array_j = j;
	  /* if (i + j > 0) lpush(0,0,localsp,localst); */
	  break; /* end itteration */
     }
     else {
	  curr=access_mat(array,i,j);
	  /* from above? */
	  if ( curr->path.flag.top_opt ) {

	    /* find shortest possible gap length */
	    /* new itterative call */
	    for (k=i-1; k >= curr->f_gap_start; k--) {
	      top=access_mat(array,k,j);
	      test_val=top->value + (convex_y * WEIGHT_INORDEL_CONV(i-k) ) + ( convex_w * WEIGHT_GAP_CONV );
	      /* test_val = v[i-k][j].val-gap_cost(k) */
	      if ( equal( test_val, curr->value) ) {
		i=k;
		goto ITR1; 
	      }
	    }
	    i=curr->f_gap_start;
	    goto ITR1; 
	  }
	  /* from the diagonal? */
	  else if (curr->path.flag.diag_opt) {
	    /* new itterative call */
	    i--;
	    j--;
	    goto ITR1; 

	  }
	  /* from the left? */
	  else if (curr->path.flag.side_opt) {
	    /* find shortest possible gap length */
	    for (k=j-1; k >= curr->e_gap_start; k--) {
	      side=access_mat(array,i,k);
	      test_val=side->value + (convex_y * WEIGHT_INORDEL_CONV(j-k) ) + ( convex_w * WEIGHT_GAP_CONV );
	      /* test_val = v[i][j-k].val-gap_cost(k) */	
	      if ( equal( test_val, curr->value) ) {
		j=k;
		goto ITR1; 
	      }
	    }
	    j=curr->e_gap_start;
	    goto ITR1; 
	  }
     }
   }
}

/***************************************************************************/
/* tracebackprev(pointer,stack): compute the prev optimal traceback	   */
/* returns 1 if successfull						   */
/* returns 0 if first trace						   */
/* returns -1 on error  						   */
/***************************************************************************/

int tracebackprev(int *lsp, stpoint *lst )
{
   int		i,j,k,len;
   char		dir;
   stpoint	p0,p1;
   double	side_val,test_val,top_val;
   Max_node 	*curr,*top,*side;

   while(1)
   {
     if ((*lsp)==1) {
	/* first trace */
        p0=lpop(lsp, lst);
	tracebackfirst(p0.i, p0.j, lsp, lst);
     	return 0;
     }
     p1=lpop(lsp,lst);
     p0=lpop(lsp,lst);
     lpush(p0.i, p0.j, lsp, lst);
     if ( (p0.i-p1.i) > 0 && (p0.j-p1.j) > 0) {
	/* from the diag */
	dir=DIAG;
	len=1;
     }
     else if ( (p0.i-p1.i) > 0 && (p0.j-p1.j)==0) {
	/* from the top */
	dir=UP;
	len=(p0.i-p1.i);
     }
     else {
	/* from the left */
	dir=SIDE;
	len=(p0.j-p1.j);
     }
     i=p0.i;
     j=p0.j;
     curr=access_mat(array,i,j);
     /* now find previous coalignment counterclockwise */
     if (dir==UP) {
       /* first try for longer gap */
       if (len < i-curr->f_gap_start ) {
	 for (k=i-len-1; k >= curr->f_gap_start; k--) {
	   top=access_mat(array,k,j);
	   test_val=top->value + (convex_y * WEIGHT_INORDEL_CONV(i-k)) + (convex_w * WEIGHT_GAP_CONV);
	   /* test_val = v[i-k][j].val-gap_cost(k) */
	   if ( equal(test_val, curr->value) ) {
	     tracebacklast(k, j, lsp, lst);
	     return(1);
	   }
	 }
	 tracebacklast(curr->f_gap_start, j, lsp, lst);
	 return(1);
       }
       /* then try for diag */
       if ( curr->path.flag.diag_opt ) {
	 tracebacklast(i-1,j-1,lsp,lst);
	 return(1);
       }
       /* try for side */
       if ( curr->path.flag.side_opt ) {
	 /* choose shortest */
	 for (k=j-1; k >= curr->e_gap_start; k--) {
	   side=access_mat(array,i,k);
	   test_val=side->value + (convex_y * WEIGHT_INORDEL_CONV(j-k) ) + ( convex_w * WEIGHT_GAP_CONV );
	   /* test_val = v[i][j-k].val-gap_cost(k) */
	   if ( equal( test_val, curr->value ) ) {
	     tracebacklast(i, k, lsp, lst);
	     return(1);
	   }
	 }
	 tracebacklast(i, curr->e_gap_start, lsp, lst);
	 return(1);
       }
     }
     else if (dir==DIAG) {
       /* try for side */
       if ( curr->path.flag.side_opt ) {
	 /* choose shortest */
	 for (k=j-1; k >= curr->e_gap_start; k--) {
	   side=access_mat(array,i,j-k);
	   test_val=side->value + (convex_y * WEIGHT_INORDEL_CONV(j-k) ) + ( convex_w * WEIGHT_GAP_CONV );
	   /* test_val = v[i][j-k].val-gap_cost(k) */
	   if ( equal( test_val, curr->value) ) {
	     tracebacklast(i, k, lsp, lst);
	     return(1);
	   }
	 }
	 tracebacklast(i, curr->e_gap_start, lsp, lst);
	 return(1);
       }
     }
     else  { 
       /* dir = SIDE */
       /* try for longer gap */
       if (len < j-curr->e_gap_start ) {
	 for (k=j-len-1; k>=curr->e_gap_start; k--) { 
	   side=access_mat(array,i,k);
	   test_val=side->value + (convex_y * WEIGHT_INORDEL_CONV(j-k) ) + ( convex_w * WEIGHT_GAP_CONV );
	   /* test_val = v[i][j-k].val-gap_cost(k) */	   
	   if ( equal( test_val, curr->value) ) {
	     tracebacklast(i, k, lsp, lst);
	     return(1);
	   }
	 }
	 tracebacklast(i, curr->e_gap_start, lsp, lst);
	 return(1);
       }	
     }
     /* cooptimal not found at current node go further up */
   }
}     

/***************************************************************************/
/* tracebackfirst(n,m): compute the first optimal traceback                */
/***************************************************************************/

void tracebackfirst(int n, int m, int *localsp, stpoint *localst )
{
   int i,j,k;
   Max_node 	*curr;

   i=n;
   j=m;
   while(1)
   {
     curr=access_mat(array,i,j);
     lpush(i,j,localsp,localst);
     if (i == 0 || j == 0 || (!curr->path.flags) ) {
       /* stop recursion and output alignment */
       /* set end location of alignment */
	  align_end_array_i = i;
          align_end_array_j = j;
	  /* if (i + j > 0) lpush(0,0,localsp,localst); */
	  break; /* end itteration */
     }
     else {
	  /* take the leftmost (counterclockwise-most) path */
	  /* from the left? */
	  curr=access_mat(array,i,j);

	  if (curr->path.flag.side_opt) {

	       /* find longest possible gap length */
	       j=curr->e_gap_start;
	       continue;
	       
	  }

	  /* from the diagonal? */
	  else if (curr->path.flag.diag_opt) {
	       i--;
	       j--;
	       continue;
	  }
	  /* from the above? */
	  else { 
	       /*(curr->path.flag.top_opt)*/ 
	       /* find longest possible gap length */
	       i=curr->f_gap_start;
	       continue;
	  }
     }
   }
}

/*************************************************************/
/*************************************************************/
/* END: CONVEX TRACEBACK FUNCTIONS			     */
/*************************************************************/
/*************************************************************/


void    get_first_align_path_nogaps(    Max_node        *array)
{
    Max_node    *curr;
    char        *align_path_wk;
    int         i,
                j;

    get_align_start_array_ij();

    align_path_wk = align_path - 1;
    i = align_start_array_i;
    j = align_start_array_j;

    curr = access_mat(array, i, j);

    while (curr->path.flags)
    {
        align_path_wk++;
        //  => ((i > 0) || (j > 0))
        if  (curr->path.flag.top_opt == 1)
        {
            i--;
            curr -= (len2 + 1);
            *align_path_wk = UP;
        }
        else if  (curr->path.flag.diag_opt == 1)
        {
            i--;
            j--;
            curr -= (len2 + 2);
            *align_path_wk = DIAG;
        }
        else //  =>  (curr->path.flag.side_opt == 1)
        {
            j--;
            curr--;
            *align_path_wk = SIDE;
        }
    }

    align_end_array_i = i;
    align_end_array_j = j;
    align_path_last = align_path_wk;
    *(align_path_last + 1) = '\0';
    align_number = 1;
}

int     found_next_start()
{
    Max_node    *curr;
    int         found_another_start;
    int         i,
                j;
    //  There are no other co-optimal alignments with this starting point
    //    -- see if there is another starting point.
    found_another_start = 0;
    if  (scoring_method == ENDGAPS_FREE)
    {
        i = align_start_array_i;
        j = align_start_array_j;
        if  (   (i == len1)
             && (j < len2))
        {
            j++;
            curr = access_mat(array, i, j);
            while (j <= len2)
            {
                if  (   (curr->value == align_max_val)
                     || (equal(curr->value, align_max_val)))
                {
                    found_another_start = 1;
                    break;
                }
                j++;
                curr++;
            }
        }
        if  (   (!found_another_start)
             && (i > 0))
        {
            j = len2;
            i--;
            curr = access_mat(array, i, j);
            while (i >= 0)
            {
                if  (   (curr->value == align_max_val)
                     || (equal(curr->value, align_max_val)))
                {
                    found_another_start = 1;
                    break;
                }
                i--;
                curr -= (len2 + 1);
            }
        }
    }
    else if  (scoring_method == LOCAL)
    {
        if  (align_max_val > 0)
        {
            i = align_start_array_i;
            j = align_start_array_j;
            if  (   (i < len1)
                 || (j < len2))
            {
                if  (j < len2)
                    j++;
                else
                {
                    i++;
                    j = 0;
                }
                curr = access_mat(array, i, j);
                while (j <= len2)
                {
                    if  (   (curr->value == align_max_val)
                         || (equal(curr->value, align_max_val)))
                    {
                        found_another_start = 1;
                        break;
                    }
                    j++;
                    curr++;
                }
                if  (   (!found_another_start)
                     && (i < len2))
                {
                    i++;
                    j = 0;
                    curr = (access_mat(array, i, j)) - 1;
                    for (; i <= len1; i++)
                    {
                        for (j = 0; j <= len2; j++)
                        {
                            curr++;
                            if  (   (curr->value == align_max_val)
                                 || (equal(curr->value, align_max_val)))
                            {
                                found_another_start = 1;
                                break;
                            }
                        }
                        if  (found_another_start)
                            break;
                    }
                }
            }
        }
    }
    else if  (scoring_method == SUBSTRING_1_OF_2)
    {
        i = align_start_array_i;
        j = align_start_array_j + 1;
        curr = access_mat(array, i, j);
        while (j <= len2)
        {
            if  (   (curr->value == align_max_val)
                 || (equal(curr->value, align_max_val)))
            {
                found_another_start = 1;
                break;
            }
            j++;
            curr++;
        }
    }
    if  (found_another_start)
    {
        align_start_array_i = i;
        align_start_array_j = j;
        curr = access_mat(array, i, j);
    }

    return found_another_start;
}


int     found_prev_start()
{
    Max_node    *curr;
    int         found_another_start;
    int         i,
                j;
    //  There are no other co-optimal alignments with this starting point
    //    -- see if there is another starting point.
    found_another_start = 0;
    if  (scoring_method == ENDGAPS_FREE)
    {
        i = align_start_array_i;
        j = align_start_array_j;
        if  (i < len1)
        {
            i++;
            curr = access_mat(array, i, j);
            while (i <= len1)
            {
                if  (   (curr->value == align_max_val)
                     || (equal(curr->value, align_max_val)))
                {
                    found_another_start = 1;
                    break;
                }
                i++;
                curr += (len2 + 1);
            }
        }
        if  (!found_another_start)
        {
            i = len1;
            j = len2 - 1;
            curr = access_mat(array, i, j);
            while (j <= 0)
            {
                if  (   (curr->value == align_max_val)
                     || (equal(curr->value, align_max_val)))
                {
                    found_another_start = 1;
                    break;
                }
                j--;
                curr--;
            }
        }
    }
    else if  (scoring_method == LOCAL)
    {
        if  (align_max_val > 0)
        {
            i = align_start_array_i;
            j = align_start_array_j;
            if  (   (i > 0)
                 || (j > 0))
            {
                if  (j > 0)
                    j--;
                else
                {
                    i--;
                    j = len2;
                }
                curr = access_mat(array, i, j);
                while (j >= 0)
                {
                    if  (   (curr->value == align_max_val)
                         || (equal(curr->value, align_max_val)))
                    {
                        found_another_start = 1;
                        break;
                    }
                    j--;
                    curr--;
                }
                if  (   (!found_another_start)
                     && (i > 0))
                {
                    i--;
                    j = len2;
                    curr = (access_mat(array, i, j)) + 1;
                    for (; i >= 0; i--)
                    {
                        for (j = len2; j >= 0; j--)
                        {
                            curr--;
                            if  (   (curr->value == align_max_val)
                                 || (equal(curr->value, align_max_val)))
                            {
                                found_another_start = 1;
                                break;
                            }
                        }
                        if  (found_another_start)
                            break;
                    }
                }
            }
        }
    }
    else if  (scoring_method == SUBSTRING_1_OF_2)
    {
        i = align_start_array_i;
        j = align_start_array_j - 1;
        curr = access_mat(array, i, j);
        while (j >= 0)
        {
            if  (   (curr->value == align_max_val)
                 || (equal(curr->value, align_max_val)))
            {
                found_another_start = 1;
                break;
            }
            j--;
            curr--;
        }
    }
    if  (found_another_start)
    {
        align_start_array_i = i;
        align_start_array_j = j;
        curr = access_mat(array, i, j);
    }

    return found_another_start;
}


int     get_next_align_path_nogaps(Max_node  *array)
{
    Max_node    *curr;
    char        *align_path_wk;
    int         i,
                j;
    int         got_a_new_start = 0;

    i = align_end_array_i;
    j = align_end_array_j;
    curr = access_mat(array, i, j);
    align_path_wk = align_path_last;

    while (align_path_wk >= align_path)
    {
        if  (*align_path_wk == UP)
        {
            i++;
            curr += (len2 + 1);
            if  (curr->path.flag.diag_opt == 1)
            {
                *align_path_wk = DIAG;
                i--;
                j--;
                curr -= (len2 + 2);
                break;
            }
            else if  (curr->path.flag.side_opt == 1)
            {
                *align_path_wk = SIDE;
                j--;
                curr--;
                break;
            }
            //  If got here then there was no alternative for this one.
            //    (Try the next).
        }
        else if  (*align_path_wk == DIAG)
        {
            i++;
            j++;
            curr += (len2 + 2);
            if  (curr->path.flag.side_opt == 1)
            {
                *align_path_wk = SIDE;
                j--;
                curr--;
                break;
            }
            //  If got here then there was no alternative for this one.
            //    (Try the next).
        }
        else //  (*align_path_wk == SIDE)
        {
            //  There is no alternative for this one.
            //    (Try the next).
            j++;
            curr++;
        }
        align_path_wk--;
    }
    if  (align_path_wk < align_path)
    {
        if  (got_a_new_start = found_next_start())
        {
            i = align_start_array_i;
            j = align_start_array_j;
            curr = access_mat(array, i, j);
        }
    }
    if  (   (align_path_wk >= align_path)
         || (got_a_new_start))
    {
        //  There is another co-optimal alignment -- find it
        while (curr->path.flags)
        {
            align_path_wk++;
            //  => ((i > 0) || (j > 0))
            if  (curr->path.flag.top_opt == 1)
            {
                i--;
                curr -= (len2 + 1);
                *align_path_wk = UP;
            }
            else if  (curr->path.flag.diag_opt == 1)
            {
                i--;
                j--;
                curr -= (len2 + 2);
                *align_path_wk = DIAG;
            }
            else //  =>  (curr->path.flag.side_opt == 1)
            {
                j--;
                curr--;
                *align_path_wk = SIDE;
            }
        }

        align_end_array_i = i;
        align_end_array_j = j;
        align_path_last = align_path_wk;
        *(align_path_last + 1) = '\0';
        align_number++;

        return 1;
    }

    return 0;
}


int     get_prev_align_path_nogaps(     Max_node        *array)
{
    Max_node    *curr;
    char        *align_path_wk;
    int         i,
                j;
    int         got_a_new_start = 0;

    i = align_end_array_i;
    j = align_end_array_j;
    curr = access_mat(array, i, j);
    align_path_wk = align_path_last;

    while (align_path_wk >= align_path)
    {
        if  (*align_path_wk == SIDE)
        {
            j++;
            curr++;
            if  (curr->path.flag.diag_opt == 1)
            {
                *align_path_wk = DIAG;
                i--;
                j--;
                curr -= (len2 + 2);
                break;
            }
            else if  (curr->path.flag.top_opt == 1)
            {
                *align_path_wk = UP;
                i--;
                curr -= (len2 + 1);
                break;
            }
            //  If got here then there was no alternative for this one.
            //    (Try the next).
        }
        else if  (*align_path_wk == DIAG)
        {
            i++;
            j++;
            curr += (len2 + 2);
            if  (curr->path.flag.top_opt == 1)
            {
                *align_path_wk = UP;
                i--;
                curr -= (len2 + 1);
                break;
            }
            //  If got here then there was no alternative for this one.
            //    (Try the next).
        }
        else //  (*align_path_wk == UP)
        {
            //  There is no alternative for this one.
            //    (Try the next).
            i++;
            curr += (len2 + 1);
        }
        align_path_wk--;
    }
    if  (align_path_wk < align_path)
    {
        if  (got_a_new_start = found_prev_start())
        {
            i = align_start_array_i;
            j = align_start_array_j;
            curr = access_mat(array, i, j);
        }
    }
    if  (   (align_path_wk >= align_path)
         || (got_a_new_start))
    {
        //  There is another co-optimal alignment -- find it
        while (curr->path.flags)
        {
            align_path_wk++;
            //  => ((i > 0) || (j > 0))
            if  (curr->path.flag.side_opt == 1)
            {
                j--;
                curr--;
                *align_path_wk = SIDE;
            }
            else if  (curr->path.flag.diag_opt == 1)
            {
                i--;
                j--;
                curr -= (len2 + 2);
                *align_path_wk = DIAG;
            }
            else //  =>  (curr->path.flag.top_opt == 1)
            {
                i--;
                curr -= (len2 + 1);
                *align_path_wk = UP;
            }
        }

        align_end_array_i = i;
        align_end_array_j = j;
        align_path_last = align_path_wk;
        *(align_path_last + 1) = '\0';
        align_number--;

        return 1;
    }

    return 0;
}


void    get_first_align_path_gaps(      Max_node        *array)
{
    Max_node    *curr;
    char        *align_path_wk;
    int         i,
                j;
    int         side_gap = 0,
                top_gap = 0;

    get_align_start_array_ij();

    align_path_wk = align_path - 1;
    i = align_start_array_i;
    j = align_start_array_j;

    curr = access_mat(array, i, j);

    while (curr->path.flags)
    {
        align_path_wk++;
        //  => ((i > 0) || (j > 0))
        if  (   (top_gap)
             && (curr->path.flag.top_cont))
        {
            i--;
            curr -= (len2 + 1);
            *align_path_wk = UP;
        }
        else if  (   (side_gap)
                  && (curr->path.flag.side_cont == 1))
        {
            if  (curr->path.flag.side_stop == 1)
            {
                if  (curr->path.flag.top_opt == 1)
                {
                    i--;
                    side_gap = 0;
                    top_gap = 1;
                    curr -= (len2 + 1);
                    *align_path_wk = UP;
                }
                else if  (curr->path.flag.diag_opt == 1)
                {
                    i--;
                    j--;
                    side_gap = 0;
                    top_gap = 0;
                    curr -= (len2 + 2);
                    *align_path_wk = DIAG;
                }
                else //  => (curr->path.flag.side_opt == 1)
                {
                    j--;
                    curr--;
                    *align_path_wk = SIDE;
                }
            }
            else
            {
                j--;
                curr--;
                *align_path_wk = SIDE;
            }
        }
        else
        {
            if  (curr->path.flag.top_opt == 1)
            {
                i--;
                side_gap = 0;
                top_gap = 1;
                curr -= (len2 + 1);
                *align_path_wk = UP;
            }
            else if  (curr->path.flag.diag_opt == 1)
            {
                i--;
                j--;
                side_gap = 0;
                top_gap = 0;
                curr -= (len2 + 2);
                *align_path_wk = DIAG;
            }
            else if  (curr->path.flag.side_opt == 1)
            {
                j--;
                side_gap = 1;
                top_gap = 0;
                curr--;
                *align_path_wk = SIDE;
            }
        }
    }
    /* set alignment end */
    align_end_array_i = i;
    align_end_array_j = j;

    align_path_last = align_path_wk;
    *(align_path_last + 1) = '\0';

    align_number = 1;
}


int     get_next_align_path_gaps(       Max_node        *array)
{
    Max_node    *curr;
    char        *align_path_wk,
                *align_path_wk2;
    char        old_path_val;
    int         i,
                j;
    int         side_gap,
                top_gap;
    int         got_a_new_start = 0;

    i = align_end_array_i;
    j = align_end_array_j;
    curr = access_mat(array, i, j);
    align_path_wk = align_path_last;

    while (align_path_wk > align_path)
    {
        align_path_wk2 = align_path_wk - 1;
        if  (*align_path_wk2 == UP)
        {
            side_gap = 0;
            top_gap = 1;
        }
        else if  (*align_path_wk2 == DIAG)
        {
            side_gap = 0;
            top_gap = 0;
        }
        else //  => ((*align_path_wk2 == SIDE)
        {
            side_gap = 1;
            top_gap = 0;
        }
        if  (*align_path_wk == UP)
        {
            i++;
            curr += (len2 + 1);

            //  Either this is a new gap, in which case
            //        (top_gap == 0)
            //  Or this gap is a continuation, in which case
            //        (   (top_gap == 1)
            //         && (curr->path.flag.top_cont == 1))
            //  So can change if
            //        (!top_gap) and there is another optimal
            //  Or
            //        (   (top_gap)
            //         && (top_stop))
            //        and there is another optimal.
            //  Combined, we get:
            if  (   (!top_gap)
                 || (curr->path.flag.top_stop == 1))
            {
                if  (curr->path.flag.diag_opt == 1)
                {
                    *align_path_wk = DIAG;
                    i--;
                    j--;
                    side_gap = 0;
                    top_gap = 0;
                    curr -= (len2 + 2);
                    break;
                }
                else if  (   (curr->path.flag.side_opt == 1)
                          || (   (side_gap)
                              && (curr->path.flag.side_cont == 1)))
                {
                    *align_path_wk = SIDE;
                    j--;
                    side_gap = 1;
                    top_gap = 0;
                    curr--;
                    break;
                }
            }
            //  If got here then there was no alternative for this one.
            //    (Try the next).
        }
        else if  (*align_path_wk == DIAG)
        {
            i++;
            j++;
            curr += (len2 + 2);
            if  (   (curr->path.flag.side_opt == 1)
                 || (   (side_gap)
                     && (curr->path.flag.side_cont == 1)))
            {
                *align_path_wk = SIDE;
                j--;
                side_gap = 1;
                top_gap = 0;
                curr--;
                break;
            }
            //  If got here then there was no alternative for this one.
            //    (Try the next).
        }
        else //  (*align_path_wk == SIDE)
        {
            //  There is no alternative for this one.
            //    (Try the next).
            j++;
            curr++;
        }
        align_path_wk--;
    }
    if  (align_path_wk == align_path)
    {
        side_gap = 0;
        top_gap = 0;
        if  (*align_path_wk == UP)
        {
            i++;
            curr += (len2 + 1);
            if   (curr->path.flag.diag_opt == 1)
            {
                *align_path_wk = DIAG;
                i--;
                j--;
                curr -= (len2 + 2);
            }
            else if  (curr->path.flag.side_opt == 1)
            {
                *align_path_wk = SIDE;
                j--;
                curr--;
            }
            else //  There is no alternative for this one.
                align_path_wk--;
        }
        else if  (*align_path_wk == DIAG)
        {
            i++;
            j++;
            curr += (len2 + 2);
            if  (curr->path.flag.side_opt == 1)
            {
                *align_path_wk = SIDE;
                j--;
                curr--;
            }
            else //  There is no alternative for this one.
                align_path_wk--;
        }
        else //   => (*align_path_wk = SIDE)
        {
            j++;
            curr++;
            //  There is no alternative for this one.
            align_path_wk--;
        }
    }

    if  (align_path_wk < align_path)
    {
        if  (got_a_new_start = found_next_start())
        {
            i = align_start_array_i;
            j = align_start_array_j;
            curr = access_mat(array, i, j);
        }
    }
    if  (   (align_path_wk >= align_path)
         || (got_a_new_start))
    {
        //  There is another co-optimal alignment -- find it
        while (curr->path.flags)
        {
            align_path_wk++;
            //  => ((i > 0) || (j > 0))
            if  (   (top_gap)
                 && (curr->path.flag.top_cont))
            {
                i--;
                curr -= (len2 + 1);
                *align_path_wk = UP;
            }
            else if  (   (side_gap)
                      && (curr->path.flag.side_cont == 1))
            {
                if  (curr->path.flag.side_stop == 1)
                {
                    if  (curr->path.flag.top_opt == 1)
                    {
                        i--;
                        side_gap = 0;
                        top_gap = 1;
                        curr -= (len2 + 1);
                        *align_path_wk = UP;
                    }
                    else if  (curr->path.flag.diag_opt == 1)
                    {
                        i--;
                        j--;
                        side_gap = 0;
                        top_gap = 0;
                        curr -= (len2 + 2);
                        *align_path_wk = DIAG;
                    }
                    else //  => (curr->path.flag.side_opt == 1)
                    {
                        j--;
                        curr--;
                        *align_path_wk = SIDE;
                    }
                }
                else
                {
                    j--;
                    curr--;
                    *align_path_wk = SIDE;
                }
            }
            else
            {
                if  (curr->path.flag.top_opt == 1)
                {
                    i--;
                    side_gap = 0;
                    top_gap = 1;
                    curr -= (len2 + 1);
                    *align_path_wk = UP;
                }
                else if  (curr->path.flag.diag_opt == 1)
                {
                    i--;
                    j--;
                    side_gap = 0;
                    top_gap = 0;
                    curr -= (len2 + 2);
                    *align_path_wk = DIAG;
                }
                else if  (curr->path.flag.side_opt == 1)
                {
                    j--;
                    side_gap = 1;
                    top_gap = 0;
                    curr--;
                    *align_path_wk = SIDE;
                }
            }
        }
        align_end_array_i = i;
        align_end_array_j = j;
        align_path_last = align_path_wk;
        *(align_path_last + 1) = '\0';
        align_number++;

        return 1;
    }

    return 0;
}


int     get_prev_align_path_gaps(       Max_node        *array)
{
    Max_node    *curr;
    char        *align_path_wk,
                *align_path_wk2;
    char        old_path_val;
    int         i,
                j;
    int         side_gap,
                top_gap;
    int         got_a_new_start = 0;

    i = align_end_array_i;
    j = align_end_array_j;
    curr = access_mat(array, i, j);
    align_path_wk = align_path_last;

    while (align_path_wk > align_path)
    {
        align_path_wk2 = align_path_wk - 1;
        if  (*align_path_wk2 == SIDE)
        {
            side_gap = 1;
            top_gap = 0;
        }
        else if  (*align_path_wk2 == DIAG)
        {
            side_gap = 0;
            top_gap = 0;
        }
        else //  => ((*align_path_wk2 == UP)
        {
            side_gap = 0;
            top_gap = 1;
        }
        if  (*align_path_wk == SIDE)
        {
            j++;
            curr++;

            //  Either this is a new gap, in which case
            //        (side_gap == 0)
            //  Or this gap is a continuation, in which case
            //        (   (side_gap == 1)
            //         && (curr->path.flag.side_cont == 1))
            //  So can change if
            //        (!side_gap) and there is another optimal
            //  Or
            //        (   (side_gap)
            //         && (side_stop))
            //        and there is another optimal.
            //  Combined, we get:
            if  (   (!side_gap)
                 || (curr->path.flag.side_stop == 1))
            {
                if  (curr->path.flag.diag_opt == 1)
                {
                    *align_path_wk = DIAG;
                    i--;
                    j--;
                    side_gap = 0;
                    top_gap = 0;
                    curr -= (len2 + 2);
                    break;
                }
                else if  (   (curr->path.flag.top_opt == 1)
                          || (   (top_gap)
                              && (curr->path.flag.top_cont == 1)))
                {
                    *align_path_wk = UP;
                    i--;
                    side_gap = 0;
                    top_gap = 1;
                    curr -= (len2 + 1);
                    break;
                }
            }
            //  If got here then there was no alternative for this one.
            //    (Try the next).
        }
        else if  (*align_path_wk == DIAG)
        {
            i++;
            j++;
            curr += (len2 + 2);
            if  (   (curr->path.flag.top_opt == 1)
                 || (   (top_gap)
                     && (curr->path.flag.top_cont == 1)))
            {
                *align_path_wk = UP;
                i--;
                side_gap = 0;
                top_gap = 1;
                curr -= (len2 + 1);
                break;
            }
            //  If got here then there was no alternative for this one.
            //    (Try the next).
        }
        else //  (*align_path_wk == UP)
        {
            //  There is no alternative for this one.
            //    (Try the next).
            i++;
            curr += (len2 + 1);
        }
        align_path_wk--;
    }
    if  (align_path_wk == align_path)
    {
        side_gap = 0;
        top_gap = 0;
        if  (*align_path_wk == SIDE)
        {
            j++;
            curr++;
            if   (curr->path.flag.diag_opt == 1)
            {
                *align_path_wk = DIAG;
                i--;
                j--;
                curr -= (len2 + 2);
            }
            else if  (curr->path.flag.top_opt == 1)
            {
                *align_path_wk = UP;
                i--;
                curr -= (len2 + 1);
            }
            else //  There is no alternative for this one.
                align_path_wk--;
        }
        else if  (*align_path_wk == DIAG)
        {
            i++;
            j++;
            curr += (len2 + 2);
            if  (curr->path.flag.top_opt == 1)
            {
                *align_path_wk = UP;
                i--;
                curr -= (len2 + 1);
            }
            else //  There is no alternative for this one.
                align_path_wk--;
        }
        else //   => (*align_path_wk = UP)
        {
            i++;
            curr += (len2 + 1);
            //  There is no alternative for this one.
            align_path_wk--;
        }
    }

    if  (align_path_wk < align_path)
    {
        if  (got_a_new_start = found_prev_start())
        {
            i = align_start_array_i;
            j = align_start_array_j;
            curr = access_mat(array, i, j);
        }
    }
    if  (   (align_path_wk >= align_path)
         || (got_a_new_start))
    {
        //  There is an earlier co-optimal alignment -- find it
        while (curr->path.flags)
        {
            align_path_wk++;
            //  => ((i > 0) || (j > 0))
            if  (   (side_gap)
                 && (curr->path.flag.side_cont))
            {
                j--;
                curr --;
                *align_path_wk = SIDE;
            }
            else if  (   (top_gap)
                      && (curr->path.flag.top_cont == 1))
            {
                if  (curr->path.flag.top_stop == 1)
                {
                    if  (curr->path.flag.side_opt == 1)
                    {
                        j--;
                        side_gap = 1;
                        top_gap = 0;
                        curr--;
                        *align_path_wk = SIDE;
                    }
                    else if  (curr->path.flag.diag_opt == 1)
                    {
                        i--;
                        j--;
                        side_gap = 0;
                        top_gap = 0;
                        curr -= (len2 + 2);
                        *align_path_wk = DIAG;
                    }
                    else //  => (curr->path.flag.top_opt == 1)
                    {
                        i--;
                        curr -= (len2 + 1);
                        *align_path_wk = UP;
                    }
                }
                else
                {
                    i--;
                    curr -= (len2 + 1);
                    *align_path_wk = UP;
                }
            }
            else
            {
                if  (curr->path.flag.side_opt == 1)
                {
                    j--;
                    side_gap = 1;
                    top_gap = 0;
                    curr--;
                    *align_path_wk = SIDE;
                }
                else if  (curr->path.flag.diag_opt == 1)
                {
                    i--;
                    j--;
                    side_gap = 0;
                    top_gap = 0;
                    curr -= (len2 + 2);
                    *align_path_wk = DIAG;
                }
                else if  (curr->path.flag.top_opt == 1)
                {
                    i--;
                    side_gap = 0;
                    top_gap = 1;
                    curr -= (len2 + 1);
                    *align_path_wk = UP;
                }
            }
        }
        align_end_array_i = i;
        align_end_array_j = j;
        align_path_last = align_path_wk;
        *(align_path_last + 1) = '\0';
        align_number--;

        return 1;
    }

    return 0;
}


void    get_first_align_path(   Max_node  *array )
{
    if  ( with_gaps && convex ) {
        get_first_align_path_convex(array);
    }
    else if ( with_gaps ) {    // nonconvex gaps
        get_first_align_path_gaps(array);
    }
    else { 
        get_first_align_path_nogaps(array);
    }
}


int     get_next_align_path(    Max_node   *array )
{
    if  ( with_gaps && convex ) {
	return get_next_align_path_convex(array);
    }
    else if ( with_gaps ) {  
        return get_next_align_path_gaps(array);
    }
    else {
        return get_next_align_path_nogaps(array);
    }
}


int     get_prev_align_path(    Max_node    *array )
{
    if  ( with_gaps && convex ) {
        return get_prev_align_path_convex(array);
    }
    else if ( with_gaps ) {
        return get_prev_align_path_gaps(array);
    }
    else {  
        return get_prev_align_path_nogaps(array);
    }
}


int     get_opt_align_ct(       Max_node        *array)
{
    int         opt_align_ct;
    int         i,
                j;
    Max_node    *curr;

    opt_align_ct = 0;

    get_first_align_path(array);
    opt_align_ct++;

    while (   (get_next_align_path(array))
           && (opt_align_ct <= 10000))
        opt_align_ct++;

    return opt_align_ct;
}


/****************************************************************/
/*  Calculates the alignment from the path.                     */
/****************************************************************/

void    calc_align_from_path(   Max_node        *array,
                                Funct           *fun)
{
    char        *align_path_wk;
    char        *align1_char,
                *align2_char;
    int         i,
                j,
                last_i_over_j,
                last_j_under_i,
                align_str_length;

/****************************************************************/
/*  IMPORTANT:                                                  */
/*    ALWAYS call calc_fun_from_path before calling this        */
/*    procedure.                                                */
/****************************************************************/

    if  (scoring_method == LOCAL)
    {
        /********************************************************/
        /*  The length needed hold the aligned strings is:      */
        /*                                                      */
        /*     max((len1 - align_start_array_i),                */
        /*         (len2 - align_start_array_j))                */
        /*     + (align_start_array_i - align_end_array_i)      */
        /*     + (align_start_array_j - align_end_array_j)      */
        /*     - match_ct - mis_ct + 3                          */
        /*     + max(align_end_array_i, align_end_array_j)      */
        /*     + 3 + 1                                          */
        /*   = max((len1 - align_start_array_i),                */
        /*         (len2 - align_start_array_j))                */
        /*     + align_start_array_i + align_start_array_j      */
        /*     - align_end_array_i - align_end_array_j          */
        /*     - match_ct - mis_ct                              */
        /*     + max(align_end_array_i, align_end_array_j)      */
        /*     + 6                                              */
        /********************************************************/
        i = len1 - align_start_array_i;
        j = len2 - align_start_array_j;

        align_str_length = ((i >= j) ? i : j)
                     + align_start_array_i + align_start_array_j
                     - align_end_array_i - align_end_array_j
                     - fun->match_ct - fun->mis_ct
                     + ((align_end_array_i >= align_end_array_j) ?
                           align_end_array_i : align_end_array_j)
                     + 6;
    }
    else
        align_str_length = len1 + len2 - fun->match_ct - fun->mis_ct;

    delete fun->align1;
    fun->align1 = new char [align_str_length + 1];

    delete fun->align2;
    fun->align2 = new char [align_str_length + 1];

    align1_char = fun->align1 + align_str_length;
    align2_char = fun->align2 + align_str_length;
    *align1_char = '\0';
    align1_char--;
    *align2_char = '\0';
    align2_char--;

    i = len1;
    j = len2;

    if  (scoring_method == LOCAL)
    {
        last_i_over_j = len2 + align_start_array_i - align_start_array_j;
        last_j_under_i = len1 + align_start_array_j - align_start_array_i;

        while  (i > last_i_over_j)
        {
            i--;
            *align1_char = str1[i];
            *align2_char = ' ';
            align1_char--;
            align2_char--;
        }
        while  (j > last_j_under_i)
        {
            j--;
            *align1_char = ' ';
            *align2_char = str2[j];
            align1_char--;
            align2_char--;
        }
        while (i > align_start_array_i)
        {
            i--;
            j--;
            *align1_char = str1[i];
            *align2_char = str2[j];
            align1_char--;
            align2_char--;
        }

        *align1_char = ' ';
        *align2_char = ' ';
        align1_char--;
        align2_char--;
        *align1_char = ']';
        *align2_char = ']';
        align1_char--;
        align2_char--;
        *align1_char = ' ';
        *align2_char = ' ';
        align1_char--;
        align2_char--;
    }
    else
    {
        while (i > align_start_array_i)
        {
            i--;
            *align1_char = str1[i];
            align1_char--;
            *align2_char = '~';
            align2_char--;
        }
        while  (j > align_start_array_j)
        {
            j--;
            *align1_char = '~';
            align1_char--;
            *align2_char = str2[j];
            align2_char--;
        }
    }

    for (align_path_wk = align_path;
         align_path_wk <= align_path_last;
         align_path_wk++, align1_char--, align2_char--)
    {
        if  (*align_path_wk == UP)
        {
            i--;
            *align1_char = str1[i];
            *align2_char = '-';
        }
        else if  (*align_path_wk == DIAG)
        {
            i--;
            j--;
            *align1_char = str1[i];
            *align2_char = str2[j];
        }
        else //  => ((*align_path_wk == SIDE)
        {
            j--;
            *align1_char = '-';
            *align2_char = str2[j];
        }
    }

    if  (scoring_method == LOCAL)
    {
        *align1_char = ' ';
        *align2_char = ' ';
        align1_char--;
        align2_char--;
        *align1_char = '[';
        *align2_char = '[';
        align1_char--;
        align2_char--;
        *align1_char = ' ';
        *align2_char = ' ';
        align1_char--;
        align2_char--;

        while  (   (i > 0)
                && (j > 0))
        {
            i--;
            j--;
            *align1_char = str1[i];
            *align2_char = str2[j];
            align1_char--;
            align2_char--;
        }
        while  (i > 0)
        {
            i--;
            *align1_char = str1[i];
            *align2_char = ' ';
            align1_char--;
            align2_char--;
        }
        while  (j > 0)
        {
            j--;
            *align1_char = ' ';
            *align2_char = str2[j];
            align1_char--;
            align2_char--;
        }
    }
    else
    {
        while  (i > 0)
        {
            i--;
            *align1_char = str1[i];
            align1_char--;
            *align2_char = '~';
            align2_char--;
        }
        while  (j > 0)
        {
            j--;
            *align1_char = '~';
            align1_char--;
            *align2_char = str2[j];
            align2_char--;
        }
    }
}


void    calc_fun_from_path(Funct   *fun) // convexified
{
    if  (!weights_in_array) {
	if ( with_gaps && convex)
        	calc_convex_fun_from_path_c(fun);		
	else
        	calc_fun_from_path_c(fun);
    }
    else {
	if ( with_gaps && convex)
        	calc_convex_fun_from_path_c(fun);		
	else
        	calc_fun_from_path_c(fun);
    }
}


/****************************************************************/
/* This is the dynamic programming routine used to find optimal */
/* functions and alignments at a given point.                   */
/* It calls the respective procedures for the given setting.    */
/****************************************************************/

Funct   *find_max(      Point   *pt,
                        int     do_align)
{
    Funct       *fun;

    if  (!weights_in_array)
        fun = find_max_c_fast(pt, do_align);
    else //  => (weights_in_array)
        fun = find_max_w_fast(pt, do_align);

    pt->max_val = pt->eval(fun, opt_function);
    if  (input_fun)
    {
        pt->input_fun_val = pt->eval(input_fun, opt_function);
        pt->diff_val = pt->max_val - pt->input_fun_val;
    }
    pt->dist_sq_val = ((pt->x - minval_x) * (pt->x - minval_x))
                    + ((pt->y - minval_y) * (pt->y - minval_y));

    number_opts++;

    return fun;
}

Funct   *find_max_count(      Point   *pt,
                              int     do_align)
{
    Funct       *fun;

    if  (!weights_in_array)
        fun = find_max_c(pt, do_align);
    else //  => (weights_in_array)
        fun = find_max_w(pt, do_align);

    pt->max_val = pt->eval(fun, opt_function);
    if  (input_fun)
    {
        pt->input_fun_val = pt->eval(input_fun, opt_function);
        pt->diff_val = pt->max_val - pt->input_fun_val;
    }
    pt->dist_sq_val = ((pt->x - minval_x) * (pt->x - minval_x))
                    + ((pt->y - minval_y) * (pt->y - minval_y));

    number_opts++;

    return fun;
}
