/* 
**++
**  FACILITY:  University of California, Davis
**              Computer Science Department
**              Theory Lab
**
**  PROGRAM NAME:       XPARAL
**
**  MODULE DESCRIPTION:
**
**      globals_s.h -- header file with global extern declarations.
**      For use in all but the main program file.
**      A matching header file (globals_m.h) with declarations and
**      definitions is to be used with the main (xparal.c) module file.
**
**  AUTHORS:
**      Paul F. Stelling
**      Jim Knight
**      Justin Bronder
**      Douglas Mayfield
**      K. Balasubramanian
**
**  CREATION DATE:      04/25/1991
**
**  MODIFICATION HISTORY:
**
**      05/02/91        J. Bronder      use Motif widgets
**      1992-1995       P. Stelling     corrected and improved
**                                        algorithmic approach
**                                        (including new/revised data structures)
**                                      read strings from file
**                                      reverse strings
**                                      specify region
**                                      output performance statistics (log)
**                                      save alignment/polygon info to a file
**      1994            J. Knight       remove Motif -- use all Xt Intrinsics
**      1995            P. Stelling     read in a reference alignment
**                                      compute values for input alignment
**                                        and display them
**
*/

extern struct stat      log_buf;
extern char             *log_fname;
extern FILE             *log_fp;

/************************************************************************/
/*                                                                      */
/*  Set up the string matching global variables                         */
/*                                                                      */
/************************************************************************/

extern unsigned char    *str1,
                        *str2;
extern int              len1,
                        len2;
extern int              opt_function,
                        scoring_method,
                        with_gaps;  	/* 0 = no gaps, 1  = with gaps */

 /* added for convex gaps */

extern int              convex;  	/* 0 or 1 */

extern stpoint		*gst;

extern int		gsp;

extern double           convex_y;
extern double           convex_w;

extern double           *gap_size_weight;
extern int		max_gap_size;

extern int              have_minval_poly,
                        number_corners,
                        number_opts,
                        number_polys;
extern int              weights_in_array;

extern double           *weight_matrix_array;
extern double           maxval_x,
                        maxval_y;
extern double           minval_x,
                        minval_y;
extern double           Global_v,
                        Global_w;

extern Funct            *display_fun,
                        *input_fun;

extern Funct_list       *fun_list;

extern Max_node         *array;

extern Point            *display_pt,
                        *display_fun_pt;

extern char             *align_path,
                        *align_path_last;
extern int              align_number;
extern int              align_end_array_i,
                        align_end_array_j,
                        align_start_array_i,
                        align_start_array_j;
extern double           align_max_val;

extern Poly             *dark_poly,
                        *last_poly,
                        *poly_list;
extern Todo             *todo_list;

extern Cursor           hourglass;

extern Widget           toplevel,
                        input_align_diff_label;

extern Image_data       hack_data,
                        *my_data;

extern char             *inputaligndiff_blank,
                        *inputaligndiff_noinput,
                        *inputaligndiff;

/* convex n^2logn implementation lists */
extern lpoint		*elist, **flist;

extern int		ept, *fpt;
