/*
**++
**  FACILITY:  University of California, Davis
**              Computer Science Department
**              Theory Lab
**
**  PROGRAM NAME:       XPARAL
**
**  MODULE DESCRIPTION:
**
**      This is the header file for the weighting function to be used
**      in the dynamic programming (dynam.c).
**      -paral.c
**
*/

#define WEIGHT_MATCH(A, B)      (weight_matrix_array[\
                                        ( (((int)(A))-weight_alphabet_min_as_int)\
                                         *weight_matrix_array_size)\
                                        +((int)(B))-weight_alphabet_min_as_int])

#define WEIGHT_MISMATCH(A, B)   (weight_matrix_array[\
                                        ( (((int)(A))-weight_alphabet_min_as_int)\
                                         *weight_matrix_array_size)\
                                        +((int)(B))-weight_alphabet_min_as_int])

#define WEIGHT_INORDEL ( -1.0 )

#define WEIGHT_INORDEL_CONV(A) (-(gap_size_weight[(A)]))

#define WEIGHT_GAP (-1.0)

#define WEIGHT_GAP_CONV (-1.0)

extern int      weight_alphabet_min_as_int,
                weight_matrix_array_size;

extern double   *weight_matrix_array;

// These are the names of the (now) internalized weight matrices. -- Mars
extern char *PAM250_MAT;
extern char *PAM250_8_MAT;
extern char *BLOSUM80_MAT;
extern char *BLOSUM62_MAT;
extern char *BLOSUM45_MAT;
extern char *GONNET_MAT;
extern char *GRIBSKOW_MAT;
extern char *MCCLURE_MAT;
extern char *TAYLOR_MAT;