// $Id: CfgCompact.java,v 1.19 2003/09/22 21:31:56 hchen Exp $

import java.io.*;
import java.util.*;
import gnu.getopt.*;

/**
 * End user application to compact a CFG
 */
public class CfgCompact
{
  static final String optionString = "e:f:i:m:o:" + Util.getOptionString(),
    optionUsage =
    "Usage: CfgCompact [options] -m meta_FSA [-e entry_function]+\n" +
    "Options:\n" +
    "  -m <file>\tUse <file> as the Meta-FSA\n" +
    "  -i <file>\tRead the input from <file>\n" +
    "  -o <file>\tWrite the output to <file>\n" +
    "  -e <name>\tSet <name> to be the entry function\n" +
    "  -f <file>\tRead entry function names from <file> (one name per line)\n" +
    Util.getOptionUsage();
  
  public static void main(String args[]) throws IOException
  {
    Cfg cfg = new Cfg();
    String cfgInFilename = "-", cfgOutFilename = "-", mfsaFilename = null;
    MetaFsa metaFsa;
    // Calendar calendar;
    Getopt opt;
    int ch;
    HashMap entryFunctions;
    String label, entryFunctionFileName = null;;

    entryFunctions = new HashMap();
    opt = new Getopt("CfgCompact", args, optionString, Util.getLongOpts());
    while ((ch = opt.getopt()) != -1)
    {
      switch(ch)
      {
	case 'm':
	  mfsaFilename = opt.getOptarg();
	  break;

	case 'i':
	  cfgInFilename = opt.getOptarg();
	  break;

	case 'e':
	  label = opt.getOptarg();
	  if (entryFunctions.containsKey(label))
	  {
	    Util.warn(Util.WARNING, Util.FILE_IO, "redundant entry function " + label);
	  }
	  else
	  {
	    entryFunctions.put(label, null);
	  }
	  break;

	case 'f':
	  entryFunctionFileName = opt.getOptarg();
	  break;
	  
	case 'o':
	  cfgOutFilename = opt.getOptarg();
	  break;

	default:
	  Util.processOption(ch, opt, optionUsage);
      }
    }

    if (entryFunctionFileName != null)
      Util.readEntryFunctions(entryFunctionFileName, entryFunctions);
    
    if (mfsaFilename == null || entryFunctions.size() == 0)
    {
      Util.stderr.println(optionUsage);
      System.exit(1);
    }
    
    metaFsa = new MetaFsa();
    metaFsa.read(mfsaFilename);
    //calendar = new GregorianCalendar();
    //Util.stderr.println("Reading cfg " + calendar.getTime());
    cfg.read(cfgInFilename, true);
    //calendar = new GregorianCalendar();
    //Util.stderr.println("Compacting cfg " + calendar.getTime());
    cfg.compact(metaFsa, entryFunctions);
    //calendar = new GregorianCalendar();
    //Util.stderr.println("Writing cfg " + calendar.getTime());
    cfg.write(cfgOutFilename, true, null);
    //calendar = new GregorianCalendar();
    //Util.stderr.println("Done " + calendar.getTime());
  }
}
