// $Id: PdaTransition.java,v 1.7 2003/09/22 21:31:57 hchen Exp $

import java.util.*;

/**
 * Represents a transition in PDA
 */
public class PdaTransition extends FsaTransition
{
  /**
   * The order of these fields are important, as they determine how to
   * calculate hashCode(BitSet).
   */
  public int stack0, stack1, stack2;

  public PdaTransition(int state0, Object input, int state1,
		       int stack0, int stack1, int stack2)
  {
    super(state0, input, state1);
    this.stack0 = stack0;
    this.stack1 = stack1;
    this.stack2 = stack2;
  }

  public PdaTransition()
  {
    super();
  }

  /**
   * Overrides FsaTransition.equals()
   */
  public boolean equals(Record record)
  {
    PdaTransition t = (PdaTransition)record;
    
    return super.equals(t) && 
      stack0 == t.stack0 && stack1 == t.stack1 && stack2 == t.stack2;
  }

  /**
   * Overrides FsaTransition.matches()
   */
  public boolean matches(Record record, BitSet fields)
  {
    PdaTransition t = (PdaTransition)record;
    
    return
      super.matches(record, fields) &&
      (!fields.get(3) || t.stack0 == stack0) &&
      (!fields.get(4) || t.stack1 == stack1) &&
      (!fields.get(5) || t.stack2 == stack2);
  }

  /**
   * Overrides FsaTransition.expand()
   */
  public FsaTransition expand(int newState0, int newState1, int dim)
  {
    return new PdaTransition(newState0 * dim + state0, input,
			     newState1 * dim + state1, stack0, stack1, stack2);
  }

  /**
   * Overrides FsaTransition.hashCode()
   */
  public int hashCode(BitSet fields)
  {
    int value, shift, mask;
    
    if (Util.isDebug() && fields.length() > 6)
      Util.die(Util.INTERNAL, "Max index >= 6 when indexing PdaTransition objects");

    shift = 32 / fields.cardinality();
    mask = (int)(1L << shift) - 1;
    value = 0;
    if (fields.get(0))
      value = (value << shift) + (state0 & mask);
    if (fields.get(1))
      value = (value << shift) + (input.hashCode() & mask);
    if (fields.get(2))
      value = (value << shift) + (state1 & mask);
    if (fields.get(3))
      value = (value << shift) + (stack0 & mask);
    if (fields.get(4))
      value = (value << shift) + (stack1 & mask);
    if (fields.get(5))
      value = (value << shift) + (stack2 & mask);

    return value;
  }
}
