// $Id: ResolveAstNode.java,v 1.1 2003/10/18 12:56:01 geoffcm Exp $

import java.io.*;
import gnu.getopt.*;

public class ResolveAstNode
{
    static final String optionString = "i:n:" + Util.getOptionString(),
	optionUsage =
	"Usage: ResolveAstNode [options] -n <number>\n" +
	"  -i <file>\tRead input from <file>\n" +
	"  -n <number>\tFind the function call with AST node <number>\n" +
	Util.getOptionUsage();

    public static void main(String[] args) throws IOException {
	Getopt opt;
	int ch;
	String inputFileName = "-", nodeString = null;
	int node = -1;
    
	opt = new Getopt("ResolveAstNode", args, optionString,
			 Util.getLongOpts());
	while ((ch = opt.getopt()) != -1) {
	    switch(ch) {
	    case 'i':
		inputFileName = opt.getOptarg();
		break;
	    case 'n':
		nodeString = opt.getOptarg();
		break;
	  
	    default:
		Util.processOption(ch, opt, optionUsage);
	    }
	}
	if ((args.length - opt.getOptind()) != 0) {
	    Util.stderr.println(optionUsage);
	    System.exit(1);
	}
	if (nodeString == null) {
	    Util.stderr.println("You must specify a node to resolve.");
	    System.exit(1);
	}
	try {
	    node = Integer.parseInt(nodeString);
	}
	catch (NumberFormatException nfe) {
	    Util.stderr.println("You must specify a numeric node ID.");
	    System.exit(1);
	}
	if (node < 0) {
	    Util.stderr.println("Node IDs may not be negative");
	    System.exit(1);
	}

	run(inputFileName, node);
    }

    static void run(String inputFilename, int node) throws IOException {
	BinaryInput input;
	int token;

	input = new BinaryInput(
	    new BufferedInputStream(Util.openInputStream(inputFilename)),
	    inputFilename);

	while (input.isOk()) {
	    token = input.nextToken();
	    if (token == Constants.INT &&
		input.intValue() == node && print_function_name(input))
		return;
	    else if (token < 0 || token > Constants.MAX_TOKEN) {
		Util.stderr.println("Token out of range: " + token +
				    ".  Maybe " + inputFilename + 
				    " is not a MOPS binary file?");
		System.exit(1);
	    }
	}
    }


    /* Check for the "function_call { <number> identifier <value>" sequence;
     * output <value> if found.
     */
    private static boolean print_function_name(BinaryInput input)
	throws IOException {
	int token;

	token = input.nextToken();
	if (! input.isOk() || token != Constants.BYTE ||
	    Constants.kindLabels[input.byteValue()] != "function_call")
	    return false;

	token = input.nextToken();
	if (! input.isOk() || Constants.tokenLabels[token] != "{")
	    return false;

	token = input.nextToken();
	if (! input.isOk() || token != Constants.INT)
	    return false;

	token = input.nextToken();
	if (! input.isOk() || token != Constants.BYTE ||
	    Constants.kindLabels[input.byteValue()] != "identifier")
	    return false;

	token = input.nextToken();
	if (! input.isOk() || token != Constants.STRING)
	    return false;

	System.out.println(input.stringValue());
	return true;
    }
}
