// $Id: TextInput.java,v 1.6 2003/10/21 04:39:32 hchen Exp $

import java.io.*;

class TextInput extends Input
{
  public TextInput(Reader inputReader, String filename)
  {
    super(filename);
    reader = new PushbackReader(inputReader);
    st = new StreamTokenizer(reader);
    st.eolIsSignificant(false);
    // consider '_' and '*' as regular characters
    st.wordChars('_', '_');
    st.wordChars('*', '*');
    //st.wordChars(':', ':');
    // Override the default, which is to consider '/' a comment character
    //st.wordChars('/', '/');
    st.slashStarComments(true);
    st.slashSlashComments(true);
  }
  
  // Returns STRING or -1
  public int nextToken() throws IOException
  {
    int ch;
    
    conversionOk = true;
    st.nextToken();
    switch(st.ttype)
    {
      case StreamTokenizer.TT_EOF:
	eof = true;
	tokenOk = false;
	return -1;

      default:
	tokenOk = true;
	return Constants.STRING;
    }
  }

  // Returns tokens
  public int tokenValue()
  {
    String str;
    Integer i;

    switch(st.ttype)
    {
      case StreamTokenizer.TT_EOF:
      case '\"':
      case StreamTokenizer.TT_NUMBER:
      // Should not see TT_EOL, because I have set st.eolIsSignificant(false),
      // but just be safe
      case StreamTokenizer.TT_EOL:
	conversionOk = false;
	return -1;

      default:
	str = stringValue();
	if ((i = (Integer)Constants.tokenInt.get(str)) == null)
	{
	  conversionOk = false;
	  return -1;
	}
	else
	{
	  conversionOk = true;
	  return i.intValue();
	}
    }
  }
  
  public int byteValue()
  {
    Integer i;
    String str;

    str = stringValue();
    i = (Integer)Constants.kindInt.get(str);
    if (i == null)
    {
      conversionOk = false;
      return Constants.kind_unmatched;
    }
    else
    {
      conversionOk = true;
      return i.intValue();
    }
  }
  
  public int intValue()
  {
    if (st.ttype != StreamTokenizer.TT_NUMBER)
    {
      conversionOk = false;
      return -1;
    }
    else
    {
      conversionOk = true;
      return (int)st.nval;
    }
  }
  
  public String stringValue()
  {
    conversionOk = true;
    switch(st.ttype)
    {
      case StreamTokenizer.TT_WORD:
      case '\"':
	return st.sval;
	
      case StreamTokenizer.TT_NUMBER:
	return Integer.toString((int)st.nval);

      case StreamTokenizer.TT_EOL:
      case StreamTokenizer.TT_EOF:
	return null;

      default:
	return new String(new byte[] {(byte)st.ttype});
    }
  }
  
  public int getLineNumber()
  {
    return st.lineno();
  }

  public void close() throws IOException
  {
    reader.close();
  }
  
  StreamTokenizer st;
  PushbackReader reader;
}
