#include "eve_parameters.h"

Eve_parameters* Eve_parameters::m_pInstance = NULL;


Eve_parameters::Eve_parameters()
{
  // for description of the fields see comments in eve_parameters_declarations.h

  param.general.n_signals=2;

  param.energy.initial_energy = 800000;

  param.network.creation = 0.000005;
  param.network.destruction = 0.000005;
  param.network.mild_mutation = 0.00005;
  param.network.strong_mutation = 0.00002;
  param.network.evolvability = 0.2;
  param.network.initial_sensor_prob = 0.1;
    
  param.grid.n = 10;
  param.grid.dmax = sqrt(2.0)*10;
  param.grid.diff_probability = 5e-04;
  param.grid.diff_sdev = 2;
  param.grid.division_copy_sdev = 2;
  param.grid.if_global_min = 1;
  param.grid.search_radius = param.grid.dmax;

  param.lgt.if_coonect_metabolic = 0;

  param.lgt.tf_probability = 0e-06;
  param.lgt.tf_link_probability = 5e-02;
  param.lgt.tf_dist_middle = 10;
  param.lgt.tf_dist_slope  = 10; 
  param.lgt.tf_size_middle = 3;
  param.lgt.tf_size_slope  = 1;

  param.lgt.cj_probability = 0e-06;
  param.lgt.cj_link_probability = 5e-02;
  param.lgt.cj_dist_middle = 10;
  param.lgt.cj_dist_slope  = 10; 
  param.lgt.cj_size_middle = 3;
  param.lgt.cj_size_slope  = 1;

  param.lgt.td_probability = 0e-06;
  param.lgt.td_link_probability = 5e-02;
  param.lgt.td_dist_middle = 10;
  param.lgt.td_dist_slope  = 10; 
  param.lgt.td_size_middle = 3;
  param.lgt.td_size_slope  = 1;

}


Eve_parameters* Eve_parameters::getInstance()
{
  if ( m_pInstance == NULL ) 
    m_pInstance = new Eve_parameters();
  
  return m_pInstance;
}

void Eve_parameters::destroyInstance()
{
  delete m_pInstance;
  m_pInstance = NULL;
}

